/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.json.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.diff.JsonDiff;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.json.JsonDiffProcessor;
import io.gravitee.apim.infra.json.jackson.JsonMapperFactory;
import java.util.Arrays;

public class JacksonJsonDiffProcessor
implements JsonDiffProcessor {
    private final ObjectMapper mapper;

    public JacksonJsonDiffProcessor() {
        this.mapper = JsonMapperFactory.build();
    }

    public JacksonJsonDiffProcessor(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String diff(Object object1, Object object2) {
        String oldJson = object1 == null ? "{}" : ((ObjectNode)this.mapper.convertValue(object1, ObjectNode.class)).remove(Arrays.asList("updatedAt", "createdAt")).toString();
        String newJson = object2 == null ? "{}" : ((ObjectNode)this.mapper.convertValue(object2, ObjectNode.class)).remove(Arrays.asList("updatedAt", "createdAt")).toString();
        try {
            return JsonDiff.asJson((JsonNode)this.mapper.readTree(oldJson), (JsonNode)this.mapper.readTree(newJson)).toString();
        }
        catch (JsonProcessingException e) {
            throw new TechnicalDomainException("Error while computing JSON diff", e);
        }
    }
}

