/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.VerifyApiHostsDomainService;
import io.gravitee.apim.core.api.domain_service.VerifyApiPathDomainService;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.category.domain_service.ValidateCategoryIdsDomainService;
import io.gravitee.apim.core.documentation.domain_service.ValidatePagesDomainService;
import io.gravitee.apim.core.group.domain_service.ValidateGroupsDomainService;
import io.gravitee.apim.core.member.domain_service.ValidateCRDMembersDomainService;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.plan.domain_service.ValidatePlanDomainService;
import io.gravitee.apim.core.resource.domain_service.ValidateResourceDomainService;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.nativeapi.kafka.KafkaListener;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@DomainService
public class ValidateApiCRDDomainService
implements Validator<Input> {
    private final ValidateCategoryIdsDomainService categoryIdsValidator;
    private final VerifyApiPathDomainService apiPathValidator;
    private final VerifyApiHostsDomainService apiHostValidator;
    private final ValidateCRDMembersDomainService membersValidator;
    private final ValidateGroupsDomainService groupsValidator;
    private final ValidateResourceDomainService resourceValidator;
    private final ValidatePagesDomainService pagesValidator;
    private final ValidatePlanDomainService planValidator;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        ApiCRDSpec.ApiCRDSpecBuilder sanitizedBuilder = input.spec().toBuilder();
        if (input.spec.isNative()) {
            this.validateAndSanitizeNativeV4ForCreation(input, sanitizedBuilder, errors);
        } else {
            this.validateAndSanitizeHttpV4ForCreation(input, sanitizedBuilder, errors);
        }
        this.categoryIdsValidator.validateAndSanitize(new ValidateCategoryIdsDomainService.Input(input.auditInfo().environmentId(), input.spec().getCategories())).peek(sanitized -> sanitizedBuilder.categories(sanitized.idOrKeys()), errors::addAll);
        this.membersValidator.validateAndSanitize(new ValidateCRDMembersDomainService.Input(input.auditInfo(), MembershipReferenceType.API, input.spec().getMembers())).peek(sanitized -> sanitizedBuilder.members(sanitized.members()), errors::addAll);
        this.groupsValidator.validateAndSanitize(new ValidateGroupsDomainService.Input(input.auditInfo.environmentId(), input.spec().getGroups(), input.spec().getDefinitionVersion())).peek(sanitized -> sanitizedBuilder.groups(sanitized.groups()), errors::addAll);
        this.resourceValidator.validateAndSanitize(new ValidateResourceDomainService.Input(input.auditInfo.environmentId(), input.spec().getResources())).peek(sanitized -> sanitizedBuilder.resources(sanitized.resources()), errors::addAll);
        this.pagesValidator.validateAndSanitize(new ValidatePagesDomainService.Input(input.auditInfo, input.spec.getId(), input.spec.getPages())).peek(sanitized -> sanitizedBuilder.pages(sanitized.pages()), errors::addAll);
        this.planValidator.validateAndSanitize(new ValidatePlanDomainService.Input(input.auditInfo, input.spec, input.spec.getPlans())).peek(sanitized -> sanitizedBuilder.plans(sanitized.plans()), errors::addAll);
        return Validator.Result.ofBoth(new Input(input.auditInfo(), sanitizedBuilder.build()), errors);
    }

    private void validateAndSanitizeHttpV4ForCreation(Input input, ApiCRDSpec.ApiCRDSpecBuilder sanitizedBuilder, ArrayList<Validator.Error> errors) {
        this.apiPathValidator.validateAndSanitize(new VerifyApiPathDomainService.Input(input.auditInfo.environmentId(), input.spec.getId(), input.spec.getPaths())).peek(sanitized -> sanitizedBuilder.paths(sanitized.paths()), errors::addAll);
    }

    private void validateAndSanitizeNativeV4ForCreation(Input input, ApiCRDSpec.ApiCRDSpecBuilder sanitizedBuilder, ArrayList<Validator.Error> errors) {
        ArrayList listeners = new ArrayList();
        input.spec.getListeners().forEach(listener -> {
            try {
                KafkaListener kafkaListener = (KafkaListener)listener;
                if (this.apiHostValidator.checkApiHosts(input.auditInfo.environmentId(), input.spec.getId(), List.of(kafkaListener.getHost()), ListenerType.KAFKA)) {
                    listeners.add((KafkaListener)listener);
                }
            }
            catch (Exception e) {
                errors.add(Validator.Error.severe(e.getMessage(), new Object[0]));
            }
        });
        sanitizedBuilder.listeners(listeners);
    }

    @Generated
    public ValidateApiCRDDomainService(ValidateCategoryIdsDomainService categoryIdsValidator, VerifyApiPathDomainService apiPathValidator, VerifyApiHostsDomainService apiHostValidator, ValidateCRDMembersDomainService membersValidator, ValidateGroupsDomainService groupsValidator, ValidateResourceDomainService resourceValidator, ValidatePagesDomainService pagesValidator, ValidatePlanDomainService planValidator) {
        this.categoryIdsValidator = categoryIdsValidator;
        this.apiPathValidator = apiPathValidator;
        this.apiHostValidator = apiHostValidator;
        this.membersValidator = membersValidator;
        this.groupsValidator = groupsValidator;
        this.resourceValidator = resourceValidator;
        this.pagesValidator = pagesValidator;
        this.planValidator = planValidator;
    }

    public record Input(AuditInfo auditInfo, ApiCRDSpec spec) implements Validator.Input
    {
    }
}

