/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.NewHttpApi;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.definition.jackson.datatype.GraviteeMapper;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.cockpit.services.V4ApiServiceCockpit;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.v4.ApiService;
import io.gravitee.rest.api.service.v4.ApiStateService;
import io.reactivex.rxjava3.core.Single;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class V4ApiServiceCockpitImpl
implements V4ApiServiceCockpit {
    public static final String NEW_API_ENTITY_NODE = "/newApiEntity";
    public static final String PLAN_ENTITIES_NODE = "/planEntities";
    public static final String METADATA_NODE = "/metadata";
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final ValidateApiDomainService validateApiDomainService;
    private final CreateApiDomainService createApiDomainService;
    private final ApiService apiServiceV4;
    private final ApiStateService apiStateService;
    private final GraviteeMapper graviteeMapper;
    private final ObjectMapper mapper;

    public V4ApiServiceCockpitImpl(ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, ValidateApiDomainService validateApiDomainService, CreateApiDomainService createApiDomainService, ApiService apiServiceV4, ApiStateService apiStateService) {
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.validateApiDomainService = validateApiDomainService;
        this.createApiDomainService = createApiDomainService;
        this.apiServiceV4 = apiServiceV4;
        this.apiStateService = apiStateService;
        this.graviteeMapper = new GraviteeMapper();
        this.mapper = new ObjectMapper();
    }

    @Override
    public Single<ApiEntity> createPublishApi(String organizationId, String environmentId, String userId, String apiDefinition) throws JsonProcessingException {
        JsonNode node = this.mapper.readTree(apiDefinition);
        UpdateApiEntity updateApiEntity = this.getUpdateApiEntity(node);
        ExecutionContext executionContext = new ExecutionContext(organizationId, environmentId);
        PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(organizationId, environmentId, userId);
        AuditInfo auditInfo = new AuditInfo(organizationId, environmentId, AuditActor.builder().userId(userId).build());
        return Single.just((Object)this.createApiDomainService.create(this.deserializeApi(node, environmentId), primaryOwner, auditInfo, api -> this.validateApiDomainService.validateAndSanitizeForCreation((Api)api, primaryOwner, environmentId, organizationId), ApiIndexerDomainService.oneShotIndexation(auditInfo))).flatMap(api -> this.publishApi(executionContext, (Api)api, userId, updateApiEntity)).flatMap(apiEntity -> this.syncDeployment(executionContext, apiEntity.getId(), userId));
    }

    private Api deserializeApi(JsonNode node, String environmentId) throws JsonProcessingException {
        String newApiEntityNode = this.mapper.writeValueAsString((Object)node.at(NEW_API_ENTITY_NODE));
        NewHttpApi newApi = (NewHttpApi)this.graviteeMapper.readValue(newApiEntityNode, NewHttpApi.class);
        return ApiModelFactory.fromNewHttpApi(newApi, environmentId);
    }

    private UpdateApiEntity getUpdateApiEntity(JsonNode node) throws JsonProcessingException {
        String newApiEntityNode = this.mapper.writeValueAsString((Object)node.at(NEW_API_ENTITY_NODE));
        String planEntitiesNode = this.mapper.writeValueAsString((Object)node.at(PLAN_ENTITIES_NODE));
        String metaDataNode = this.mapper.writeValueAsString((Object)node.at(METADATA_NODE));
        UpdateApiEntity updateApiEntity = (UpdateApiEntity)this.graviteeMapper.readValue(newApiEntityNode, UpdateApiEntity.class);
        PlanEntity[] planEntities = (PlanEntity[])this.graviteeMapper.readValue(planEntitiesNode, PlanEntity[].class);
        ApiMetadataEntity[] apiMetadataEntities = (ApiMetadataEntity[])this.graviteeMapper.readValue(metaDataNode, ApiMetadataEntity[].class);
        updateApiEntity.setPlans(new HashSet<PlanEntity>(Arrays.asList(planEntities)));
        updateApiEntity.setMetadata(List.of(apiMetadataEntities));
        return updateApiEntity;
    }

    private Single<ApiEntity> syncDeployment(ExecutionContext executionContext, String apiId, String userId) {
        ApiDeploymentEntity deploymentEntity = new ApiDeploymentEntity();
        return Single.just((Object)((ApiEntity)this.apiStateService.deploy(executionContext, apiId, userId, deploymentEntity)));
    }

    private Single<ApiEntity> publishApi(ExecutionContext executionContext, Api api, String userId, UpdateApiEntity updateApiEntity) {
        UpdateApiEntity apiToUpdate = this.createUpdateApiEntity(api, updateApiEntity);
        ApiEntity update = this.apiServiceV4.update(executionContext, api.getId(), apiToUpdate, userId);
        return Single.just((Object)((ApiEntity)this.apiStateService.start(executionContext, update.getId(), userId)));
    }

    private UpdateApiEntity createUpdateApiEntity(Api api, UpdateApiEntity updateApiEntity) {
        UpdateApiEntity entity = new UpdateApiEntity();
        entity.setId(api.getId());
        entity.setName(api.getName());
        entity.setApiVersion(api.getVersion());
        entity.setDefinitionVersion(api.getDefinitionVersion());
        entity.setType(api.getType());
        entity.setDescription(api.getDescription());
        entity.setEndpointGroups(api.getApiDefinitionHttpV4().getEndpointGroups());
        entity.setAnalytics(api.getApiDefinitionHttpV4().getAnalytics());
        entity.setFlows(api.getApiDefinitionHttpV4().getFlows());
        entity.setFlowExecution(api.getApiDefinitionHttpV4().getFlowExecution());
        entity.setResponseTemplates(api.getApiDefinitionHttpV4().getResponseTemplates());
        entity.setServices(api.getApiDefinitionHttpV4().getServices());
        entity.setGroups(api.getGroups());
        entity.setVisibility(Visibility.PUBLIC);
        entity.setPicture(api.getPicture());
        entity.setCategories(api.getCategories());
        entity.setLabels(api.getLabels());
        entity.setLifecycleState(ApiLifecycleState.PUBLISHED);
        entity.setDisableMembershipNotifications(api.isDisableMembershipNotifications());
        entity.setBackground(api.getBackground());
        entity.setMetadata(updateApiEntity.getMetadata());
        entity.setProperties(updateApiEntity.getProperties());
        entity.setResources(updateApiEntity.getResources());
        entity.setPlans(updateApiEntity.getPlans());
        entity.setListeners(updateApiEntity.getListeners());
        return entity;
    }
}

