/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.specgen;

import io.gravitee.apim.core.specgen.model.ApiSpecGen;
import io.gravitee.apim.core.specgen.query_service.ApiSpecGenQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApiSpecGenQueryServiceImpl
implements ApiSpecGenQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSpecGenQueryServiceImpl.class);
    private final ApiRepository apiRepository;

    public ApiSpecGenQueryServiceImpl(@Lazy ApiRepository apiRepository) {
        this.apiRepository = apiRepository;
    }

    @Override
    public Optional<ApiSpecGen> findByIdAndType(ExecutionContext context, String id, ApiType type) {
        return this.findById(context, id).filter(api -> type.equals((Object)api.type()));
    }

    private Optional<ApiSpecGen> findById(ExecutionContext context, String id) {
        try {
            return this.apiRepository.findById((Object)id).filter(api -> DefinitionVersion.V4.equals((Object)api.getDefinitionVersion())).filter(api -> api.getEnvironmentId().equals(context.getEnvironmentId())).map(api -> new ApiSpecGen(api.getId(), api.getName(), api.getDescription(), api.getVersion(), api.getType(), api.getEnvironmentId(), api.getDefinition()));
        }
        catch (TechnicalException e) {
            log.error("An unexpected error has occurred", (Throwable)e);
            return Optional.empty();
        }
    }
}

