/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.portal_menu_link;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink;
import io.gravitee.apim.core.portal_menu_link.model.PortalMenuLinkVisibility;
import io.gravitee.apim.core.portal_menu_link.query_service.PortalMenuLinkQueryService;
import io.gravitee.apim.infra.adapter.PortalMenuLinkAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalMenuLinkRepository;
import io.gravitee.repository.management.model.PortalMenuLink;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PortalMenuLinkQueryServiceImpl
implements PortalMenuLinkQueryService {
    private final PortalMenuLinkRepository portalMenuLinkRepository;
    private final PortalMenuLinkAdapter portalMenuLinkAdapter = PortalMenuLinkAdapter.INSTANCE;
    private static final Logger logger = LoggerFactory.getLogger(PortalMenuLinkQueryServiceImpl.class);

    public PortalMenuLinkQueryServiceImpl(@Lazy PortalMenuLinkRepository portalMenuLinkRepository) {
        this.portalMenuLinkRepository = portalMenuLinkRepository;
    }

    @Override
    public List<PortalMenuLink> findByEnvironmentIdSortByOrder(String environmentId) {
        try {
            List result = this.portalMenuLinkRepository.findByEnvironmentIdSortByOrder(environmentId);
            return result.stream().map(this.portalMenuLinkAdapter::toEntity).toList();
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while searching portal menu links by environment ID %s", environmentId);
            logger.error(errorMessage, (Throwable)e);
            throw new TechnicalDomainException(errorMessage, e);
        }
    }

    @Override
    public List<PortalMenuLink> findByEnvironmentIdAndVisibilitySortByOrder(String environmentId, PortalMenuLinkVisibility visibility) {
        try {
            List result = this.portalMenuLinkRepository.findByEnvironmentIdAndVisibilitySortByOrder(environmentId, PortalMenuLink.PortalMenuLinkVisibility.valueOf((String)visibility.name()));
            return result.stream().map(this.portalMenuLinkAdapter::toEntity).toList();
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while searching portal menu links by environment ID %s and visibility %s", new Object[]{environmentId, visibility});
            logger.error(errorMessage, (Throwable)e);
            throw new TechnicalDomainException(errorMessage, e);
        }
    }
}

