/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.documentation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.documentation.domain_service.PageSourceDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.PageSource;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.fetcher.api.Fetcher;
import io.gravitee.fetcher.api.FetcherConfiguration;
import io.gravitee.fetcher.api.FetcherException;
import io.gravitee.fetcher.api.Resource;
import io.gravitee.fetcher.api.Sensitive;
import io.gravitee.plugin.core.api.PluginManager;
import io.gravitee.plugin.fetcher.FetcherPlugin;
import io.gravitee.rest.api.fetcher.FetcherConfigurationFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class PageSourceDomainServiceImpl
implements PageSourceDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageSourceDomainServiceImpl.class);
    public static final String SENSITIVE_DATA_REPLACEMENT = "********";
    private final FetcherConfigurationFactory fetcherConfigurationFactory;
    private final PluginManager<FetcherPlugin<?>> pluginManager;
    private final ApplicationContext applicationContext;

    @Override
    public void setContentFromSource(Page page) {
        this.loadFetcher(page).ifPresentOrElse(fetcher -> this.fetchContent((Fetcher)fetcher, page), () -> page.setUseAutoFetch(false));
    }

    @Override
    public void removeSensitiveData(Page page) {
        this.loadFetcher(page).ifPresent(fetcher -> {
            Field[] fields;
            FetcherConfiguration fetcherConfiguration = fetcher.getConfiguration();
            for (Field field : fields = fetcherConfiguration.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Sensitive.class)) continue;
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    field.set(fetcherConfiguration, SENSITIVE_DATA_REPLACEMENT);
                }
                catch (IllegalAccessException e) {
                    log.error("Error while removing fetcher sensitive data", (Throwable)e);
                }
                field.setAccessible(accessible);
            }
            page.getSource().setConfiguration(new ObjectMapper().valueToTree((Object)fetcherConfiguration).toString());
        });
    }

    @Override
    public void mergeSensitiveData(Page oldPage, Page newPage) {
        if (oldPage.getSource() == null || newPage.getSource() == null) {
            return;
        }
        if (oldPage.getSource().getConfiguration() == null || newPage.getSource().getConfiguration() == null) {
            return;
        }
        Optional<Fetcher> oldFetcherOpt = this.loadFetcher(oldPage);
        Optional<Fetcher> newFetcherOpt = this.loadFetcher(newPage);
        if (oldFetcherOpt.isPresent() && newFetcherOpt.isPresent()) {
            Field[] fields;
            Fetcher oldFetcher = oldFetcherOpt.get();
            Fetcher newFetcher = newFetcherOpt.get();
            FetcherConfiguration originalFetcherConfiguration = oldFetcher.getConfiguration();
            FetcherConfiguration updatedFetcherConfiguration = newFetcher.getConfiguration();
            boolean updated = false;
            for (Field field : fields = originalFetcherConfiguration.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Sensitive.class)) continue;
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    Object updatedValue = field.get(updatedFetcherConfiguration);
                    if (SENSITIVE_DATA_REPLACEMENT.equals(updatedValue)) {
                        updated = true;
                        field.set(updatedFetcherConfiguration, field.get(originalFetcherConfiguration));
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    log.error("Error while merging original fetcher sensitive data to new fetcher", (Throwable)e);
                }
                field.setAccessible(accessible);
            }
            if (updated) {
                newPage.getSource().setConfiguration(new ObjectMapper().valueToTree((Object)updatedFetcherConfiguration).toString());
            }
        }
    }

    private void fetchContent(Fetcher fetcher, Page page) {
        if (page.getType() != Page.Type.ROOT) {
            page.setContent(this.readContent(fetcher, page.getSource()));
        }
        page.setUseAutoFetch(fetcher.getConfiguration().isAutoFetch());
    }

    private String readContent(Fetcher fetcher, PageSource source) {
        try {
            Resource resource = fetcher.fetch();
            InputStream content = resource.getContent();
            return new String(content.readAllBytes(), Charset.defaultCharset());
        }
        catch (FetcherException | IOException e) {
            throw new TechnicalDomainException("unable to fetch content with configuration " + source.getConfiguration());
        }
    }

    private Optional<Fetcher> loadFetcher(Page page) {
        return Optional.ofNullable(page.getSource()).flatMap(this::loadPlugin).map(plugin -> this.buildFetcher((FetcherPlugin<?>)plugin, page.getSource()));
    }

    private Optional<FetcherPlugin<?>> loadPlugin(PageSource source) {
        return Optional.ofNullable((FetcherPlugin)this.pluginManager.get(source.getType()));
    }

    private Fetcher buildFetcher(FetcherPlugin<?> plugin, PageSource source) {
        try {
            ClassLoader classLoader = plugin.fetcher().getClassLoader();
            Class<?> configClass = classLoader.loadClass(plugin.configuration().getName());
            FetcherConfiguration config = this.fetcherConfigurationFactory.create(configClass, source.getConfiguration());
            Class<?> fetcherClass = classLoader.loadClass(plugin.clazz());
            Fetcher fetcher = (Fetcher)fetcherClass.getConstructor(configClass).newInstance(config);
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)fetcher);
            return fetcher;
        }
        catch (Exception e) {
            throw new TechnicalDomainException("unable to build fetcher instance", e);
        }
    }

    @Generated
    public PageSourceDomainServiceImpl(FetcherConfigurationFactory fetcherConfigurationFactory, PluginManager<FetcherPlugin<?>> pluginManager, ApplicationContext applicationContext) {
        this.fetcherConfigurationFactory = fetcherConfigurationFactory;
        this.pluginManager = pluginManager;
        this.applicationContext = applicationContext;
    }
}

