/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service.property;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.property.EncryptableProperty;
import io.gravitee.common.util.DataEncryptor;
import io.gravitee.definition.model.v4.property.Property;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class PropertyDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertyDomainService.class);
    private final DataEncryptor dataEncryptor;

    public List<Property> encryptProperties(List<EncryptableProperty> apiProperties) {
        if (apiProperties == null) {
            return new ArrayList<Property>();
        }
        return apiProperties.stream().map(this::encryptProperty).filter(Objects::nonNull).toList();
    }

    private Property encryptProperty(EncryptableProperty property) {
        if (property == null) {
            return null;
        }
        Property.PropertyBuilder<?, ?> asPropertyBuilder = property.toPropertyBuilder();
        if (property.isEncryptable() && !property.isEncrypted()) {
            try {
                asPropertyBuilder.value(this.dataEncryptor.encrypt(property.getValue())).encrypted(true);
            }
            catch (GeneralSecurityException e) {
                log.error("Error encrypting property value", (Throwable)e);
            }
        }
        return asPropertyBuilder.build();
    }

    @Generated
    public PropertyDomainService(DataEncryptor dataEncryptor) {
        this.dataEncryptor = dataEncryptor;
    }
}

