/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.group.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.group.crud_service.GroupCrudService;
import io.gravitee.apim.core.group.domain_service.ValidateGroupCRDDomainService;
import io.gravitee.apim.core.group.model.crd.GroupCRDSpec;
import io.gravitee.apim.core.group.model.crd.GroupCRDStatus;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.member.domain_service.CRDMembersDomainService;
import io.gravitee.apim.core.validation.Validator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class ImportGroupCRDUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportGroupCRDUseCase.class);
    private final ValidateGroupCRDDomainService validationService;
    private final GroupQueryService queryService;
    private final GroupCrudService crudService;
    private final CRDMembersDomainService membersService;

    public ImportGroupCRDUseCase(ValidateGroupCRDDomainService validationService, GroupQueryService queryService, GroupCrudService crudService, CRDMembersDomainService membersService) {
        this.validationService = validationService;
        this.queryService = queryService;
        this.crudService = crudService;
        this.membersService = membersService;
    }

    public Output execute(Input input) {
        return this.queryService.findById(input.spec.getId()).map(existing -> this.update(input)).orElseGet(() -> this.create(input));
    }

    private Output create(Input input) {
        Validator.Result<ValidateGroupCRDDomainService.Input> validationResult = this.validationService.validateAndSanitize(new ValidateGroupCRDDomainService.Input(input.auditInfo, input.spec));
        validationResult.severe().ifPresent(errors -> {
            throw new TechnicalDomainException(((Validator.Error)errors.iterator().next()).getMessage());
        });
        GroupCRDStatus.Errors errors2 = validationResult.errors().map(GroupCRDStatus.Errors::fromErrorList).orElse(GroupCRDStatus.Errors.EMPTY);
        this.crudService.create(input.spec.toGroup(input.auditInfo.environmentId()));
        this.membersService.updateGroupMembers(input.auditInfo, input.spec.getId(), input.spec.getMembers());
        return new Output(new GroupCRDStatus(input.spec.getId(), input.spec.getMembers().size(), errors2));
    }

    private Output update(Input input) {
        Validator.Result<ValidateGroupCRDDomainService.Input> validationResult = this.validationService.validateAndSanitize(new ValidateGroupCRDDomainService.Input(input.auditInfo, input.spec));
        validationResult.severe().ifPresent(errors -> {
            throw new TechnicalDomainException(((Validator.Error)errors.iterator().next()).getMessage());
        });
        GroupCRDStatus.Errors errors2 = validationResult.errors().map(GroupCRDStatus.Errors::fromErrorList).orElse(GroupCRDStatus.Errors.EMPTY);
        this.crudService.update(input.spec.toGroup(input.auditInfo.environmentId()));
        this.membersService.updateGroupMembers(input.auditInfo, input.spec.getId(), input.spec.getMembers());
        return new Output(new GroupCRDStatus(input.spec.getId(), input.spec.getMembers().size(), errors2));
    }

    public record Input(AuditInfo auditInfo, GroupCRDSpec spec) implements Validator.Input
    {
    }

    public record Output(GroupCRDStatus status) {
    }
}

