/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.model.ResponseStatusOvertime;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.utils.DurationUtils;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchEnvironmentResponseStatusOverTimeUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchEnvironmentResponseStatusOverTimeUseCase.class);
    private final AnalyticsQueryService analyticsQueryService;
    private final ApiQueryService apiQueryService;

    public Output execute(ExecutionContext executionContext, Input input) {
        Duration interval = DurationUtils.buildIntervalFromTimePeriod(input.from(), input.to());
        Map<DefinitionVersion, List<String>> apiIdsByDefinitionVersion = this.apisIdsForEnv(input.environmentId);
        List<String> apiIds = apiIdsByDefinitionVersion.values().stream().flatMap(Collection::stream).toList();
        ResponseStatusOvertime result = this.analyticsQueryService.searchResponseStatusOvertime(executionContext, new AnalyticsQueryService.ResponseStatusOverTimeQuery(apiIds, input.from(), input.to(), interval, apiIdsByDefinitionVersion.keySet()));
        return new Output(result);
    }

    private Map<DefinitionVersion, List<String>> apisIdsForEnv(String envId) {
        return this.apiQueryService.search(ApiSearchCriteria.builder().environmentId(envId).definitionVersion(EnumSet.of(DefinitionVersion.V4, DefinitionVersion.V2)).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).collect(Collectors.groupingBy(SearchEnvironmentResponseStatusOverTimeUseCase::getDefinitionVersion, Collectors.mapping(Api::getId, Collectors.toList())));
    }

    private static DefinitionVersion getDefinitionVersion(Api api) {
        return api.getDefinitionVersion() != null ? api.getDefinitionVersion() : DefinitionVersion.V2;
    }

    @Generated
    public SearchEnvironmentResponseStatusOverTimeUseCase(AnalyticsQueryService analyticsQueryService, ApiQueryService apiQueryService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiQueryService = apiQueryService;
    }

    public record Input(String environmentId, Instant from, Instant to) {
    }

    public record Output(ResponseStatusOvertime responseStatusOvertime) {
    }
}

