/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.User;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.notification.NotificationConfigType;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.BadNotificationConfigException;
import io.gravitee.rest.api.service.exceptions.NotificationConfigNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class GenericNotificationConfigServiceImpl
extends AbstractService
implements GenericNotificationConfigService {
    private final Logger LOGGER = LoggerFactory.getLogger(GenericNotificationConfigServiceImpl.class);
    @Lazy
    @Autowired
    GenericNotificationConfigRepository genericNotificationConfigRepository;

    @Override
    public GenericNotificationConfigEntity create(GenericNotificationConfigEntity entity) {
        if (entity.getNotifier() == null || entity.getNotifier().isEmpty() || entity.getName() == null || entity.getName().isEmpty()) {
            throw new BadNotificationConfigException();
        }
        try {
            GenericNotificationConfig notificationConfig = this.convert(entity);
            notificationConfig.setId(UuidString.generateRandom());
            notificationConfig.setCreatedAt(new Date());
            notificationConfig.setUpdatedAt(notificationConfig.getCreatedAt());
            return this.convert(this.genericNotificationConfigRepository.create(notificationConfig));
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to save the generic notification settings {}", (Object)entity, (Object)te);
            throw new TechnicalManagementException("An error occurs while trying to save the generic notification settings " + String.valueOf(entity), te);
        }
    }

    @Override
    public GenericNotificationConfigEntity update(GenericNotificationConfigEntity entity) {
        try {
            if (entity.getNotifier() == null || entity.getNotifier().isEmpty() || entity.getName() == null || entity.getName().isEmpty()) {
                throw new BadNotificationConfigException();
            }
            if (entity.getId() == null || entity.getId().isEmpty()) {
                throw new NotificationConfigNotFoundException();
            }
            Optional optionalConfig = this.genericNotificationConfigRepository.findById(entity.getId());
            if (!optionalConfig.isPresent()) {
                throw new NotificationConfigNotFoundException();
            }
            GenericNotificationConfig notificationConfig = this.convert(entity);
            notificationConfig.setCreatedAt(((GenericNotificationConfig)optionalConfig.get()).getCreatedAt());
            notificationConfig.setUpdatedAt(new Date());
            return this.convert(this.genericNotificationConfigRepository.update(notificationConfig));
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to save the generic notification settings {}", (Object)entity, (Object)te);
            throw new TechnicalManagementException("An error occurs while trying to save the generic notification settings " + String.valueOf(entity), te);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.genericNotificationConfigRepository.delete(id);
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to delete the generic notification {}", (Object)id, (Object)te);
            throw new TechnicalManagementException("An error occurs while trying to delete the generic notification " + id, te);
        }
    }

    @Override
    public void deleteReference(NotificationReferenceType referenceType, String referenceId) {
        try {
            this.genericNotificationConfigRepository.deleteByReferenceIdAndReferenceType(referenceId, referenceType);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to delete the generic notifications {} / {}", new Object[]{referenceType, referenceId, e});
            throw new TechnicalManagementException("An error occurs while trying to delete the generic notifications " + String.valueOf(referenceType) + " / " + referenceId, e);
        }
    }

    @Override
    public GenericNotificationConfigEntity findById(String id) {
        try {
            Optional optionalConfig = this.genericNotificationConfigRepository.findById(id);
            if (optionalConfig.isPresent()) {
                return this.convert((GenericNotificationConfig)optionalConfig.get());
            }
            throw new NotificationConfigNotFoundException();
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to get the notification config {}", (Object)id, (Object)te);
            throw new TechnicalManagementException("An error occurs while trying to get the notification config " + id, te);
        }
    }

    @Override
    public List<GenericNotificationConfigEntity> findByReference(NotificationReferenceType referenceType, String referenceId) {
        try {
            return this.genericNotificationConfigRepository.findByReference(referenceType, referenceId).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to get the notification config {}/{}", (Object)referenceType, (Object)referenceId);
            throw new TechnicalManagementException("An error occurs while trying to get the notification config " + String.valueOf(referenceType) + "/" + referenceId, e);
        }
    }

    @Override
    public void deleteByUser(User user) {
        try {
            if (user.getEmail() != null && !user.getEmail().isEmpty()) {
                this.genericNotificationConfigRepository.deleteByConfig(user.getEmail());
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to delete the notification config for user {}", (Object)user.getId(), (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to delete the notification config for user " + user.getId(), e);
        }
    }

    private GenericNotificationConfig convert(GenericNotificationConfigEntity entity) {
        GenericNotificationConfig model = new GenericNotificationConfig();
        model.setId(entity.getId());
        model.setName(entity.getName());
        model.setReferenceType(NotificationReferenceType.valueOf((String)entity.getReferenceType()));
        model.setReferenceId(entity.getReferenceId());
        model.setNotifier(entity.getNotifier());
        model.setConfig(entity.getConfig());
        model.setUseSystemProxy(entity.isUseSystemProxy());
        model.setHooks(entity.getHooks());
        return model;
    }

    private GenericNotificationConfigEntity convert(GenericNotificationConfig genericNotificationConfig) {
        GenericNotificationConfigEntity entity = new GenericNotificationConfigEntity();
        entity.setConfigType(NotificationConfigType.GENERIC);
        entity.setId(genericNotificationConfig.getId());
        entity.setName(genericNotificationConfig.getName());
        entity.setReferenceType(genericNotificationConfig.getReferenceType().name());
        entity.setReferenceId(genericNotificationConfig.getReferenceId());
        entity.setNotifier(genericNotificationConfig.getNotifier());
        entity.setConfig(genericNotificationConfig.getConfig());
        entity.setUseSystemProxy(genericNotificationConfig.isUseSystemProxy());
        entity.setHooks(genericNotificationConfig.getHooks());
        return entity;
    }
}

