/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.shared_policy_group;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.query_service.SharedPolicyGroupHistoryQueryService;
import io.gravitee.apim.infra.adapter.SharedPolicyGroupAdapter;
import io.gravitee.apim.infra.repository.PageUtils;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SharedPolicyGroupHistoryRepository;
import io.gravitee.repository.management.api.search.SharedPolicyGroupHistoryCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SharedPolicyGroupHistoryQueryServiceImpl
implements SharedPolicyGroupHistoryQueryService {
    private final SharedPolicyGroupHistoryRepository sharedPolicyGroupHistoryRepository;
    private final SharedPolicyGroupAdapter sharedPolicyGroupAdapter;
    private static final Logger logger = LoggerFactory.getLogger(SharedPolicyGroupHistoryQueryServiceImpl.class);

    public SharedPolicyGroupHistoryQueryServiceImpl(@Lazy SharedPolicyGroupHistoryRepository sharedPolicyGroupHistoryRepository, SharedPolicyGroupAdapter sharedPolicyGroupAdapter) {
        this.sharedPolicyGroupHistoryRepository = sharedPolicyGroupHistoryRepository;
        this.sharedPolicyGroupAdapter = sharedPolicyGroupAdapter;
    }

    @Override
    public Stream<SharedPolicyGroup> streamLatestBySharedPolicyGroupId(String environmentId) {
        try {
            return PageUtils.toStream(repositoryPageable -> this.sharedPolicyGroupHistoryRepository.searchLatestBySharedPolicyGroupId(environmentId, repositoryPageable)).map(this.sharedPolicyGroupAdapter::toEntity);
        }
        catch (TechnicalException e) {
            logger.error("An error occurred while streaming all last shared policy groups by environment ID {}", (Object)environmentId, (Object)e);
            throw new TechnicalDomainException("An error occurred while trying to stream all last shared policy groups by environment ID: " + environmentId, e);
        }
    }

    @Override
    public Page<SharedPolicyGroup> search(String environmentId, String sharedPolicyGroupId, Pageable pageable, Sortable sortable) {
        Assert.notNull((Object)environmentId, (String)"EnvironmentId must not be null");
        Assert.notNull((Object)sharedPolicyGroupId, (String)"SharedPolicyGroupId must not be null");
        try {
            SharedPolicyGroupHistoryCriteria criteria = SharedPolicyGroupHistoryCriteria.builder().sharedPolicyGroupId(sharedPolicyGroupId).environmentId(environmentId).build();
            Page result = this.sharedPolicyGroupHistoryRepository.search(criteria, new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build(), new SortableBuilder().field(sortable.getField()).setAsc(sortable.isAscOrder()).build());
            return result.map(this.sharedPolicyGroupAdapter::toEntity);
        }
        catch (TechnicalException e) {
            logger.error("An error occurred while searching shared policy group histories by environment ID {} and sharedPolicyGroupId {}", new Object[]{environmentId, sharedPolicyGroupId, e});
            throw new TechnicalDomainException(String.format("An error occurred while trying to search shared policy group histories by environment ID: %s and sharedPolicyGroupId: %s", environmentId, sharedPolicyGroupId), e);
        }
    }

    @Override
    public Optional<SharedPolicyGroup> getLatestBySharedPolicyGroupId(String environmentId, String sharedPolicyGroupId) {
        Assert.notNull((Object)environmentId, (String)"EnvironmentId must not be null");
        Assert.notNull((Object)sharedPolicyGroupId, (String)"SharedPolicyGroupId must not be null");
        try {
            return this.sharedPolicyGroupHistoryRepository.getLatestBySharedPolicyGroupId(environmentId, sharedPolicyGroupId).map(this.sharedPolicyGroupAdapter::toEntity);
        }
        catch (TechnicalException e) {
            logger.error("An error occurred while getting the latest shared policy group by environment ID {} and sharedPolicyGroupId {}", new Object[]{environmentId, sharedPolicyGroupId, e});
            throw new TechnicalDomainException(String.format("An error occurred while trying to get the latest shared policy group by environment ID: %s and sharedPolicyGroupId: %s", environmentId, sharedPolicyGroupId), e);
        }
    }
}

