/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class RatingNotFoundException
extends AbstractNotFoundException {
    private final String rating;
    private final String api;

    public RatingNotFoundException(String rating) {
        this.rating = rating;
        this.api = null;
    }

    public RatingNotFoundException(String rating, String api) {
        this.rating = rating;
        this.api = api;
    }

    @Override
    public String getMessage() {
        return "Rating [" + this.rating + "] cannot be found" + (String)(this.api == null ? "" : " on the api [" + this.api + "]");
    }

    @Override
    public String getTechnicalCode() {
        return "rating.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("rating", this.rating);
        parameters.put("api", this.api);
        return parameters;
    }
}

