/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.PageSourceDomainService;
import io.gravitee.apim.core.documentation.exception.InvalidPageParentException;
import io.gravitee.apim.core.documentation.model.Breadcrumb;
import io.gravitee.apim.core.documentation.model.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@UseCase
public class ApiGetDocumentationPagesUseCase {
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final PageSourceDomainService pageSourceDomainService;
    private final ApiCrudService apiCrudService;
    private final PageCrudService pageCrudService;

    public ApiGetDocumentationPagesUseCase(ApiDocumentationDomainService apiDocumentationDomainService, PageSourceDomainService pageSourceDomainService, ApiCrudService apiCrudService, PageCrudService pageCrudService) {
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.pageSourceDomainService = pageSourceDomainService;
        this.apiCrudService = apiCrudService;
        this.pageCrudService = pageCrudService;
    }

    public Output execute(Input input) {
        Api api = this.apiCrudService.get(input.apiId);
        ArrayList<Breadcrumb> breadcrumbList = new ArrayList<Breadcrumb>();
        if (!"ROOT".equals(input.parentId) && this.isNotEmpty(input.parentId)) {
            Page page2 = this.pageCrudService.get(input.parentId);
            this.apiDocumentationDomainService.validatePageAssociatedToApi(page2, input.apiId);
            if (!page2.isFolder()) {
                throw new InvalidPageParentException(page2.getId());
            }
            List<Page> pageBreadcrumbList = this.constructBreadcrumbs(page2).toList();
            for (int i = 0; i < pageBreadcrumbList.size(); ++i) {
                Page pageBreadcrumb = pageBreadcrumbList.get(i);
                breadcrumbList.add(Breadcrumb.builder().id(pageBreadcrumb.getId()).name(pageBreadcrumb.getName()).position(i + 1).build());
            }
        }
        List<Page> pages = this.apiDocumentationDomainService.getApiPages(input.apiId, input.parentId).stream().map(page -> page.withHidden(this.apiDocumentationDomainService.pageIsHidden((Page)page)).withGeneralConditions(this.apiDocumentationDomainService.pageIsUsedAsGeneralConditions((Page)page, api))).toList();
        pages.forEach(this.pageSourceDomainService::removeSensitiveData);
        return new Output(pages, breadcrumbList);
    }

    private Stream<Page> constructBreadcrumbs(Page page) {
        Optional<Page> parent;
        if (this.isNotEmpty(page.getParentId()) && (parent = this.pageCrudService.findById(page.getParentId())).isPresent()) {
            return Stream.concat(this.constructBreadcrumbs(parent.get()), Stream.of(page));
        }
        return Stream.of(page);
    }

    private boolean isNotEmpty(String str) {
        return !Objects.isNull(str) && !str.isEmpty();
    }

    public record Input(String apiId, String parentId) {
    }

    public record Output(List<Page> pages, List<Breadcrumb> breadcrumbList) {
    }
}

