/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PageAuditEvent;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.apim.core.search.model.IndexablePage;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;

@DomainService
public class ClearIngestedApiDocumentationDomainService {
    private final PageCrudService pageCrudService;
    private final AuditDomainService auditDomainService;
    private final Indexer indexer;
    private final PageQueryService pageQueryService;

    public void clearIngestedPagesOf(String apiId, Collection<String> keepPages, AuditInfo auditInfo) {
        this.pageQueryService.searchByApiId(apiId).stream().filter(Page::isIngested).filter(p -> !keepPages.contains(p.getName())).forEach(page -> {
            if (page.isPublished()) {
                this.indexer.delete(new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId()), new IndexablePage((Page)page));
            }
            this.pageCrudService.delete(page.getId());
            this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().apiId(page.getReferenceId()).event(PageAuditEvent.PAGE_DELETED).createdAt(page.getUpdatedAt().toInstant().atZone(ZoneId.of("UTC"))).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).actor(auditInfo.actor()).properties(Map.of(AuditProperties.PAGE, page.getId())).oldValue(page).newValue(null).build());
        });
    }

    @Generated
    public ClearIngestedApiDocumentationDomainService(PageCrudService pageCrudService, AuditDomainService auditDomainService, Indexer indexer, PageQueryService pageQueryService) {
        this.pageCrudService = pageCrudService;
        this.auditDomainService = auditDomainService;
        this.indexer = indexer;
        this.pageQueryService = pageQueryService;
    }
}

