/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.ApiExportDomainService;
import io.gravitee.apim.core.api.model.import_definition.ApiDescriptor;
import io.gravitee.apim.core.api.model.import_definition.GraviteeDefinition;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.Excludable;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class ExportApiUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportApiUseCase.class);
    private final ApiExportDomainService apiExportDomainService;

    public Output execute(Input input) {
        GraviteeDefinition exported;
        GraviteeDefinition graviteeDefinition = exported = this.apiExportDomainService.export(input.apiId(), input.auditInfo(), input.excluded());
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GraviteeDefinition.V4.class, GraviteeDefinition.Native.class}, (Object)graviteeDefinition, n)) {
            case 0 -> {
                GraviteeDefinition.V4 v4 = (GraviteeDefinition.V4)graviteeDefinition;
                yield new Output(v4);
            }
            case 1 -> {
                GraviteeDefinition.Native nativeV4 = (GraviteeDefinition.Native)graviteeDefinition;
                yield new Output(nativeV4);
            }
            case -1 -> throw new ApiNotFoundException(input.apiId());
            default -> throw new ApiDefinitionVersionNotSupportedException(exported.api().definitionVersion().getLabel());
        };
    }

    private static String getExportFilename(ApiDescriptor api) {
        return "%s-%s.json".formatted(api.name(), api.apiVersion()).trim().toLowerCase().replaceAll("[^\\w\\r\\n\\t\\f\\v.]+", "-");
    }

    @Generated
    public ExportApiUseCase(ApiExportDomainService apiExportDomainService) {
        this.apiExportDomainService = apiExportDomainService;
    }

    public record Input(String apiId, AuditInfo auditInfo, @Nullable Collection<Excludable> excluded) {
        public static Input of(String apiId, AuditInfo auditInfo, @Nullable Collection<Excludable> excluded) {
            return new Input(Objects.requireNonNull(apiId, "apiId should not be null"), Objects.requireNonNull(auditInfo, "auditInfo should not be null"), excluded == null ? List.of() : excluded);
        }
    }

    public record Output(GraviteeDefinition definition, String filename) {
        public Output(GraviteeDefinition definition) {
            this(definition, ExportApiUseCase.getExportFilename(definition.api()));
        }
    }
}

