/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.import_definition.ApiMember;
import io.gravitee.apim.core.api.model.import_definition.ApiMemberRole;
import io.gravitee.apim.core.member.model.Member;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.RoleEntity;
import java.util.List;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface MemberAdapter {
    public static final MemberAdapter INSTANCE = (MemberAdapter)Mappers.getMapper(MemberAdapter.class);

    @Mappings(value={@Mapping(target="id", source="member.memberId"), @Mapping(target="type", source="member.memberType"), @Mapping(target="displayName", expression="java(user != null ? user.displayName() : null)"), @Mapping(target="roles", expression="java(role != null ? List.of(mapRole(role)) : null)")})
    public ApiMember toApiMember(Membership var1, BaseUserEntity var2, Role var3);

    public MemberEntity toEntity(ApiMember var1);

    public Set<MemberEntity> toEntities(Set<ApiMember> var1);

    public RoleEntity toEntity(ApiMemberRole var1);

    public List<RoleEntity> toEntities(List<ApiMemberRole> var1);

    public Member toMember(MemberEntity var1);

    public MemberEntity toMemberEntity(Member var1);

    default public MembershipMemberType mapType(Membership.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Membership.Type.USER -> MembershipMemberType.USER;
            case Membership.Type.GROUP -> MembershipMemberType.GROUP;
        };
    }

    public ApiMemberRole mapRole(Role var1);
}

