/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class GetIngestedApisUseCase {
    private final ApiQueryService apiQueryService;

    public Output execute(Input input) {
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 10));
        Page<Api> ingestedApis = this.apiQueryService.findByIntegrationId(input.integrationId, pageable);
        return new Output(ingestedApis);
    }

    @Generated
    public GetIngestedApisUseCase(ApiQueryService apiQueryService) {
        this.apiQueryService = apiQueryService;
    }

    public record Input(String integrationId, Optional<Pageable> pageable) {
        public Input(String integrationId) {
            this(integrationId, Optional.empty());
        }

        public Input(String integrationId, Pageable pageable) {
            this(integrationId, Optional.of(pageable));
        }

        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String integrationId;
            @Generated
            private Optional<Pageable> pageable;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integrationId(String integrationId) {
                this.integrationId = integrationId;
                return this;
            }

            @Generated
            public InputBuilder pageable(Optional<Pageable> pageable) {
                this.pageable = pageable;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integrationId, this.pageable);
            }

            @Generated
            public String toString() {
                return "GetIngestedApisUseCase.Input.InputBuilder(integrationId=" + this.integrationId + ", pageable=" + String.valueOf(this.pageable) + ")";
            }
        }
    }

    public record Output(Page<Api> ingestedApis) {
    }
}

