/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.domain_service.ValidateUpdateSharedPolicyGroupDomainService;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupAuditEvent;
import io.gravitee.apim.core.shared_policy_group.model.UpdateSharedPolicyGroup;
import java.util.Map;
import lombok.Generated;

@UseCase
public class UpdateSharedPolicyGroupUseCase {
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;
    private final ValidateUpdateSharedPolicyGroupDomainService validateUpdateSharedPolicyGroupDomainService;
    private final AuditDomainService auditService;

    public Output execute(Input input) {
        SharedPolicyGroup existingSharedPolicyGroup = this.sharedPolicyGroupCrudService.getByEnvironmentId(input.auditInfo().environmentId(), input.sharedPolicyGroupId());
        SharedPolicyGroup sharedPolicyGroupToUpdate = existingSharedPolicyGroup.update(input.sharedPolicyGroupToUpdate());
        this.validateUpdateSharedPolicyGroupDomainService.validate(sharedPolicyGroupToUpdate, input.auditInfo().environmentId());
        SharedPolicyGroup updatedSharedPolicyGroup = this.sharedPolicyGroupCrudService.update(sharedPolicyGroupToUpdate);
        this.createAuditLog(existingSharedPolicyGroup, updatedSharedPolicyGroup, input.auditInfo());
        return new Output(updatedSharedPolicyGroup);
    }

    private void createAuditLog(SharedPolicyGroup oldSharedPolicyGroup, SharedPolicyGroup sharedPolicyGroup, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(SharedPolicyGroupAuditEvent.SHARED_POLICY_GROUP_UPDATED).actor(auditInfo.actor()).oldValue(oldSharedPolicyGroup).newValue(sharedPolicyGroup).createdAt(sharedPolicyGroup.getUpdatedAt()).properties(Map.of(AuditProperties.SHARED_POLICY_GROUP, sharedPolicyGroup.getId())).build());
    }

    @Generated
    public UpdateSharedPolicyGroupUseCase(SharedPolicyGroupCrudService sharedPolicyGroupCrudService, ValidateUpdateSharedPolicyGroupDomainService validateUpdateSharedPolicyGroupDomainService, AuditDomainService auditService) {
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
        this.validateUpdateSharedPolicyGroupDomainService = validateUpdateSharedPolicyGroupDomainService;
        this.auditService = auditService;
    }

    public record Input(String sharedPolicyGroupId, UpdateSharedPolicyGroup sharedPolicyGroupToUpdate, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String sharedPolicyGroupId;
            @Generated
            private UpdateSharedPolicyGroup sharedPolicyGroupToUpdate;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder sharedPolicyGroupId(String sharedPolicyGroupId) {
                this.sharedPolicyGroupId = sharedPolicyGroupId;
                return this;
            }

            @Generated
            public InputBuilder sharedPolicyGroupToUpdate(UpdateSharedPolicyGroup sharedPolicyGroupToUpdate) {
                this.sharedPolicyGroupToUpdate = sharedPolicyGroupToUpdate;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.sharedPolicyGroupId, this.sharedPolicyGroupToUpdate, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateSharedPolicyGroupUseCase.Input.InputBuilder(sharedPolicyGroupId=" + this.sharedPolicyGroupId + ", sharedPolicyGroupToUpdate=" + String.valueOf(this.sharedPolicyGroupToUpdate) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(SharedPolicyGroup sharedPolicyGroup) {
    }
}

