/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.model;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.documentation.model.PrimaryOwnerApiTemplateData;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.v4.ApiType;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class ApiFreemarkerTemplate {
    private String id;
    private String name;
    private String description;
    private String version;
    private DefinitionVersion definitionVersion;
    private ApiType type;
    private String picture;
    private PrimaryOwnerApiTemplateData primaryOwner;
    private Api.Visibility visibility;
    private Api.LifecycleState state;
    private Api.ApiLifecycleState lifecycleState;
    private Set<String> tags;
    private Map<String, String> metadata;
    private Date deployedAt;
    private Date createdAt;
    private Date updatedAt;
    private Proxy proxy;

    public ApiFreemarkerTemplate(Api api, Map<String, String> metadata, PrimaryOwnerEntity primaryOwner) {
        if (api == null) {
            return;
        }
        if (DefinitionVersion.V4.equals((Object)api.getDefinitionVersion())) {
            if (api.getApiDefinitionHttpV4() != null) {
                this.tags = api.getApiDefinitionHttpV4().getTags();
            }
        } else if (api.getApiDefinition() != null) {
            this.tags = api.getApiDefinition().getTags();
            this.proxy = api.getApiDefinition().getProxy();
        }
        this.state = api.getLifecycleState();
        this.lifecycleState = api.getApiLifecycleState();
        this.id = api.getId();
        this.name = api.getName();
        this.description = api.getDescription();
        this.version = api.getVersion();
        this.definitionVersion = api.getDefinitionVersion();
        this.type = api.getType();
        this.picture = api.getPicture();
        this.visibility = api.getVisibility();
        if (api.getDeployedAt() != null) {
            this.deployedAt = Date.from(api.getDeployedAt().toInstant());
        }
        if (api.getCreatedAt() != null) {
            this.createdAt = Date.from(api.getCreatedAt().toInstant());
        }
        if (api.getUpdatedAt() != null) {
            this.updatedAt = Date.from(api.getUpdatedAt().toInstant());
        }
        this.metadata = metadata;
        this.primaryOwner = PrimaryOwnerApiTemplateData.from(primaryOwner);
    }

    @Generated
    private static ApiType $default$type() {
        return ApiType.PROXY;
    }

    @Generated
    private static Api.Visibility $default$visibility() {
        return Api.Visibility.PRIVATE;
    }

    @Generated
    private static Api.LifecycleState $default$state() {
        return Api.LifecycleState.STOPPED;
    }

    @Generated
    private static Api.ApiLifecycleState $default$lifecycleState() {
        return Api.ApiLifecycleState.CREATED;
    }

    @Generated
    private static Set<String> $default$tags() {
        return new HashSet<String>();
    }

    @Generated
    private static Map<String, String> $default$metadata() {
        return new HashMap<String, String>();
    }

    @Generated
    protected ApiFreemarkerTemplate(ApiFreemarkerTemplateBuilder<?, ?> b) {
        this.id = b.id;
        this.name = b.name;
        this.description = b.description;
        this.version = b.version;
        this.definitionVersion = b.definitionVersion;
        this.type = b.type$set ? b.type$value : ApiFreemarkerTemplate.$default$type();
        this.picture = b.picture;
        this.primaryOwner = b.primaryOwner;
        this.visibility = b.visibility$set ? b.visibility$value : ApiFreemarkerTemplate.$default$visibility();
        this.state = b.state$set ? b.state$value : ApiFreemarkerTemplate.$default$state();
        this.lifecycleState = b.lifecycleState$set ? b.lifecycleState$value : ApiFreemarkerTemplate.$default$lifecycleState();
        this.tags = b.tags$set ? b.tags$value : ApiFreemarkerTemplate.$default$tags();
        this.metadata = b.metadata$set ? b.metadata$value : ApiFreemarkerTemplate.$default$metadata();
        this.deployedAt = b.deployedAt;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.proxy = b.proxy;
    }

    @Generated
    public static ApiFreemarkerTemplateBuilder<?, ?> builder() {
        return new ApiFreemarkerTemplateBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public ApiType getType() {
        return this.type;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public PrimaryOwnerApiTemplateData getPrimaryOwner() {
        return this.primaryOwner;
    }

    @Generated
    public Api.Visibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public Api.LifecycleState getState() {
        return this.state;
    }

    @Generated
    public Api.ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Date getDeployedAt() {
        return this.deployedAt;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setType(ApiType type) {
        this.type = type;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @Generated
    public void setPrimaryOwner(PrimaryOwnerApiTemplateData primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    @Generated
    public void setVisibility(Api.Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setState(Api.LifecycleState state) {
        this.state = state;
    }

    @Generated
    public void setLifecycleState(Api.ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiFreemarkerTemplate)) {
            return false;
        }
        ApiFreemarkerTemplate other = (ApiFreemarkerTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        DefinitionVersion this$definitionVersion = this.getDefinitionVersion();
        DefinitionVersion other$definitionVersion = other.getDefinitionVersion();
        if (this$definitionVersion == null ? other$definitionVersion != null : !this$definitionVersion.equals(other$definitionVersion)) {
            return false;
        }
        ApiType this$type = this.getType();
        ApiType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$picture = this.getPicture();
        String other$picture = other.getPicture();
        if (this$picture == null ? other$picture != null : !this$picture.equals(other$picture)) {
            return false;
        }
        PrimaryOwnerApiTemplateData this$primaryOwner = this.getPrimaryOwner();
        PrimaryOwnerApiTemplateData other$primaryOwner = other.getPrimaryOwner();
        if (this$primaryOwner == null ? other$primaryOwner != null : !((Object)this$primaryOwner).equals(other$primaryOwner)) {
            return false;
        }
        Api.Visibility this$visibility = this.getVisibility();
        Api.Visibility other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)((Object)this$visibility)).equals((Object)other$visibility)) {
            return false;
        }
        Api.LifecycleState this$state = this.getState();
        Api.LifecycleState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Api.ApiLifecycleState this$lifecycleState = this.getLifecycleState();
        Api.ApiLifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Date this$deployedAt = this.getDeployedAt();
        Date other$deployedAt = other.getDeployedAt();
        if (this$deployedAt == null ? other$deployedAt != null : !((Object)this$deployedAt).equals(other$deployedAt)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        return !(this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiFreemarkerTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        DefinitionVersion $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + ($definitionVersion == null ? 43 : $definitionVersion.hashCode());
        ApiType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $picture = this.getPicture();
        result = result * 59 + ($picture == null ? 43 : $picture.hashCode());
        PrimaryOwnerApiTemplateData $primaryOwner = this.getPrimaryOwner();
        result = result * 59 + ($primaryOwner == null ? 43 : ((Object)$primaryOwner).hashCode());
        Api.Visibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)((Object)$visibility)).hashCode());
        Api.LifecycleState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Api.ApiLifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Date $deployedAt = this.getDeployedAt();
        result = result * 59 + ($deployedAt == null ? 43 : ((Object)$deployedAt).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiFreemarkerTemplate(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", definitionVersion=" + String.valueOf(this.getDefinitionVersion()) + ", type=" + String.valueOf(this.getType()) + ", picture=" + this.getPicture() + ", primaryOwner=" + String.valueOf(this.getPrimaryOwner()) + ", visibility=" + String.valueOf((Object)this.getVisibility()) + ", state=" + String.valueOf((Object)this.getState()) + ", lifecycleState=" + String.valueOf((Object)this.getLifecycleState()) + ", tags=" + String.valueOf(this.getTags()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", deployedAt=" + String.valueOf(this.getDeployedAt()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", proxy=" + String.valueOf(this.getProxy()) + ")";
    }

    @Generated
    public ApiFreemarkerTemplate() {
        this.type = ApiFreemarkerTemplate.$default$type();
        this.visibility = ApiFreemarkerTemplate.$default$visibility();
        this.state = ApiFreemarkerTemplate.$default$state();
        this.lifecycleState = ApiFreemarkerTemplate.$default$lifecycleState();
        this.tags = ApiFreemarkerTemplate.$default$tags();
        this.metadata = ApiFreemarkerTemplate.$default$metadata();
    }

    @Generated
    public ApiFreemarkerTemplate(String id, String name, String description, String version, DefinitionVersion definitionVersion, ApiType type, String picture, PrimaryOwnerApiTemplateData primaryOwner, Api.Visibility visibility, Api.LifecycleState state, Api.ApiLifecycleState lifecycleState, Set<String> tags, Map<String, String> metadata, Date deployedAt, Date createdAt, Date updatedAt, Proxy proxy) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.version = version;
        this.definitionVersion = definitionVersion;
        this.type = type;
        this.picture = picture;
        this.primaryOwner = primaryOwner;
        this.visibility = visibility;
        this.state = state;
        this.lifecycleState = lifecycleState;
        this.tags = tags;
        this.metadata = metadata;
        this.deployedAt = deployedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.proxy = proxy;
    }

    @Generated
    public static abstract class ApiFreemarkerTemplateBuilder<C extends ApiFreemarkerTemplate, B extends ApiFreemarkerTemplateBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private DefinitionVersion definitionVersion;
        @Generated
        private boolean type$set;
        @Generated
        private ApiType type$value;
        @Generated
        private String picture;
        @Generated
        private PrimaryOwnerApiTemplateData primaryOwner;
        @Generated
        private boolean visibility$set;
        @Generated
        private Api.Visibility visibility$value;
        @Generated
        private boolean state$set;
        @Generated
        private Api.LifecycleState state$value;
        @Generated
        private boolean lifecycleState$set;
        @Generated
        private Api.ApiLifecycleState lifecycleState$value;
        @Generated
        private boolean tags$set;
        @Generated
        private Set<String> tags$value;
        @Generated
        private boolean metadata$set;
        @Generated
        private Map<String, String> metadata$value;
        @Generated
        private Date deployedAt;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Proxy proxy;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @Generated
        public B definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion = definitionVersion;
            return this.self();
        }

        @Generated
        public B type(ApiType type) {
            this.type$value = type;
            this.type$set = true;
            return this.self();
        }

        @Generated
        public B picture(String picture) {
            this.picture = picture;
            return this.self();
        }

        @Generated
        public B primaryOwner(PrimaryOwnerApiTemplateData primaryOwner) {
            this.primaryOwner = primaryOwner;
            return this.self();
        }

        @Generated
        public B visibility(Api.Visibility visibility) {
            this.visibility$value = visibility;
            this.visibility$set = true;
            return this.self();
        }

        @Generated
        public B state(Api.LifecycleState state) {
            this.state$value = state;
            this.state$set = true;
            return this.self();
        }

        @Generated
        public B lifecycleState(Api.ApiLifecycleState lifecycleState) {
            this.lifecycleState$value = lifecycleState;
            this.lifecycleState$set = true;
            return this.self();
        }

        @Generated
        public B tags(Set<String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this.self();
        }

        @Generated
        public B metadata(Map<String, String> metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return this.self();
        }

        @Generated
        public B deployedAt(Date deployedAt) {
            this.deployedAt = deployedAt;
            return this.self();
        }

        @Generated
        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        @Generated
        public B proxy(Proxy proxy) {
            this.proxy = proxy;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ApiFreemarkerTemplate.ApiFreemarkerTemplateBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", definitionVersion=" + String.valueOf(this.definitionVersion) + ", type$value=" + String.valueOf(this.type$value) + ", picture=" + this.picture + ", primaryOwner=" + String.valueOf(this.primaryOwner) + ", visibility$value=" + String.valueOf((Object)this.visibility$value) + ", state$value=" + String.valueOf((Object)this.state$value) + ", lifecycleState$value=" + String.valueOf((Object)this.lifecycleState$value) + ", tags$value=" + String.valueOf(this.tags$value) + ", metadata$value=" + String.valueOf(this.metadata$value) + ", deployedAt=" + String.valueOf(this.deployedAt) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", proxy=" + String.valueOf(this.proxy) + ")";
        }
    }

    @Generated
    private static final class ApiFreemarkerTemplateBuilderImpl
    extends ApiFreemarkerTemplateBuilder<ApiFreemarkerTemplate, ApiFreemarkerTemplateBuilderImpl> {
        @Generated
        private ApiFreemarkerTemplateBuilderImpl() {
        }

        @Override
        @Generated
        protected ApiFreemarkerTemplateBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ApiFreemarkerTemplate build() {
            return new ApiFreemarkerTemplate(this);
        }
    }
}

