/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.plugin.connector.ConnectorPlugin;
import io.gravitee.plugin.connector.ConnectorPluginManager;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.rest.api.model.ConnectorPluginEntity;
import io.gravitee.rest.api.service.ConnectorService;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ConnectorServiceImpl
extends AbstractPluginService<ConnectorPlugin, ConnectorPluginEntity>
implements ConnectorService {
    public ConnectorServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<ConnectorPlugin> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    public Set<ConnectorPluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public ConnectorPluginEntity findById(String connector) {
        ConnectorPlugin resourceDefinition = (ConnectorPlugin)super.get(connector);
        return this.convert((Plugin)resourceDefinition);
    }

    protected ConnectorPluginEntity convert(Plugin plugin) {
        ConnectorPluginEntity entity = new ConnectorPluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        entity.setDeployed(plugin.deployed());
        entity.setSupportedTypes(((ConnectorPluginManager)this.pluginManager).getConnector(plugin.id()).supportedTypes());
        return entity;
    }

    @Override
    public Optional<ConnectorPluginEntity> findBySupportedType(String type) {
        return super.list().stream().filter(plugin -> ((ConnectorPluginManager)this.pluginManager).getConnector(plugin.id()).supportedTypes().contains(type)).map(this::convert).findAny();
    }
}

