/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.audit.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.crud_service.AuditCrudService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.ApplicationAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditEntity;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.json.JsonDiffProcessor;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class AuditDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditDomainService.class);
    private final AuditCrudService auditCrudService;
    private final UserCrudService userCrudService;
    private final JsonDiffProcessor jsonDiffProcessor;

    public AuditDomainService(AuditCrudService auditCrudService, UserCrudService userCrudService, JsonDiffProcessor jsonDiffProcessor) {
        this.auditCrudService = auditCrudService;
        this.userCrudService = userCrudService;
        this.jsonDiffProcessor = jsonDiffProcessor;
    }

    public void createApiAuditLog(ApiAuditLogEntity audit) {
        try {
            AuditEntity entity = AuditEntity.builder().id(UuidString.generateRandom()).organizationId(audit.organizationId()).environmentId(audit.environmentId()).createdAt(audit.createdAt()).user(this.createActor(audit.actor())).properties(this.adaptAuditLogProperties(audit.properties())).referenceType(AuditEntity.AuditReferenceType.API).referenceId(audit.apiId()).event(audit.event().name()).patch(this.jsonDiffProcessor.diff(audit.oldValue(), audit.newValue())).build();
            this.auditCrudService.create(entity);
        }
        catch (TechnicalManagementException e) {
            log.error("Error occurs during the creation of an API Audit Log.", (Throwable)e);
        }
    }

    public void createApplicationAuditLog(ApplicationAuditLogEntity audit) {
        try {
            AuditEntity entity = AuditEntity.builder().id(UuidString.generateRandom()).organizationId(audit.organizationId()).environmentId(audit.environmentId()).createdAt(audit.createdAt()).user(this.createActor(audit.actor())).properties(this.adaptAuditLogProperties(audit.properties())).referenceType(AuditEntity.AuditReferenceType.APPLICATION).referenceId(audit.applicationId()).event(audit.event().name()).patch(this.jsonDiffProcessor.diff(audit.oldValue(), audit.newValue())).build();
            this.auditCrudService.create(entity);
        }
        catch (TechnicalManagementException e) {
            log.error("Error occurs during the creation of an Application Audit Log.", (Throwable)e);
        }
    }

    public void createEnvironmentAuditLog(EnvironmentAuditLogEntity audit) {
        try {
            AuditEntity entity = AuditEntity.builder().id(UuidString.generateRandom()).organizationId(audit.organizationId()).environmentId(audit.environmentId()).createdAt(audit.createdAt()).user(this.createActor(audit.actor())).properties(this.adaptAuditLogProperties(audit.properties())).referenceType(AuditEntity.AuditReferenceType.ENVIRONMENT).referenceId(audit.environmentId()).event(audit.event().name()).patch(this.jsonDiffProcessor.diff(audit.oldValue(), audit.newValue())).build();
            this.auditCrudService.create(entity);
        }
        catch (TechnicalManagementException e) {
            log.error("Error occurs during the creation of an Environment Audit Log.", (Throwable)e);
        }
    }

    private String createActor(AuditActor actor) {
        Object user = actor.userId();
        if ("token".equals(actor.userSource())) {
            user = this.userCrudService.getBaseUser(actor.userId()).displayName() + String.format(" - (using token \"%s\")", actor.userSourceId());
        }
        return user;
    }

    private Map<String, String> adaptAuditLogProperties(Map<AuditProperties, String> audit) {
        return audit.entrySet().stream().map(entry -> Map.entry(((AuditProperties)((Object)((Object)entry.getKey()))).name(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

