/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.model.AnalyticsQueryParameters;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.v4.analytics.ResponseStatusRanges;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchEnvironmentResponseStatusRangesUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchEnvironmentResponseStatusRangesUseCase.class);
    AnalyticsQueryService analyticsQueryService;
    ApiQueryService apiQueryService;

    public Output execute(Input input) {
        String envId = input.executionContext().getEnvironmentId();
        Map<DefinitionVersion, List<String>> apiIds = this.apisIdsForEnv(envId);
        List<String> apis = apiIds.values().stream().flatMap(Collection::stream).toList();
        log.debug("Searching environment API response status ranges, found: {} v4 APIs for env: {}", (Object)apis.size(), (Object)envId);
        return this.analyticsQueryService.searchResponseStatusRanges(input.executionContext(), input.parameters().withApiIds(apis).withDefinitionVersions(apiIds.keySet())).map(Output::new).orElse(new Output());
    }

    private Map<DefinitionVersion, List<String>> apisIdsForEnv(String envId) {
        return this.apiQueryService.search(ApiSearchCriteria.builder().environmentId(envId).definitionVersion(EnumSet.of(DefinitionVersion.V4, DefinitionVersion.V2)).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).collect(Collectors.groupingBy(SearchEnvironmentResponseStatusRangesUseCase::getDefinitionVersion, Collectors.mapping(Api::getId, Collectors.toList())));
    }

    private static DefinitionVersion getDefinitionVersion(Api api) {
        return api.getDefinitionVersion() != null ? api.getDefinitionVersion() : DefinitionVersion.V2;
    }

    @Generated
    public SearchEnvironmentResponseStatusRangesUseCase(AnalyticsQueryService analyticsQueryService, ApiQueryService apiQueryService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiQueryService = apiQueryService;
    }

    public record Input(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private ExecutionContext executionContext;
            @Generated
            private AnalyticsQueryParameters parameters;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder executionContext(ExecutionContext executionContext) {
                this.executionContext = executionContext;
                return this;
            }

            @Generated
            public InputBuilder parameters(AnalyticsQueryParameters parameters) {
                this.parameters = parameters;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.executionContext, this.parameters);
            }

            @Generated
            public String toString() {
                return "SearchEnvironmentResponseStatusRangesUseCase.Input.InputBuilder(executionContext=" + String.valueOf(this.executionContext) + ", parameters=" + String.valueOf(this.parameters) + ")";
            }
        }
    }

    public record Output(Optional<ResponseStatusRanges> responseStatusRanges) {
        Output(ResponseStatusRanges responseStatusRanges) {
            this(Optional.of(responseStatusRanges));
        }

        Output() {
            this(new ResponseStatusRanges());
        }
    }
}

