/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.definition.model.DefinitionVersion;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@UseCase
public class UpdateFederatedPlanUseCase {
    private final UpdatePlanDomainService updatePlanDomainService;

    public UpdateFederatedPlanUseCase(UpdatePlanDomainService updatePlanDomainService) {
        this.updatePlanDomainService = updatePlanDomainService;
    }

    public Output execute(Input input) {
        if (input.planToUpdate.getDefinitionVersion() != DefinitionVersion.FEDERATED) {
            throw new IllegalArgumentException(String.format("Can't update a %s plan", input.planToUpdate.getDefinitionVersion()));
        }
        Plan updated = this.updatePlanDomainService.update(input.planToUpdate, List.of(), Map.of(), null, input.auditInfo);
        return new Output(updated);
    }

    public record Input(Plan planToUpdate, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Plan planToUpdate;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder planToUpdate(Plan planToUpdate) {
                this.planToUpdate = planToUpdate;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.planToUpdate, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateFederatedPlanUseCase.Input.InputBuilder(planToUpdate=" + String.valueOf(this.planToUpdate) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(Plan updated) {
    }
}

