/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.NewReferenceMetadataEntity;
import io.gravitee.rest.api.model.ReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UpdateReferenceMetadataEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.AbstractReferenceMetadataService;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiMetadataServiceImpl
extends AbstractReferenceMetadataService
implements ApiMetadataService {
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;

    @Override
    public List<ApiMetadataEntity> findAllByApi(ExecutionContext executionContext, String apiId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.API, apiId, Optional.of(executionContext.getEnvironmentId()));
        return allMetadata.stream().map(m -> this.convert((ReferenceMetadataEntity)m, apiId)).collect(Collectors.toList());
    }

    @Override
    public ApiMetadataEntity findByIdAndApi(ExecutionContext executionContext, String metadataId, String apiId) {
        return this.convert(this.findByIdAndReference(metadataId, MetadataReferenceType.API, apiId, Optional.of(executionContext.getEnvironmentId())), apiId);
    }

    @Override
    public void delete(ExecutionContext executionContext, String metadataId, String apiId) {
        this.delete(executionContext, metadataId, MetadataReferenceType.API, apiId);
    }

    @Override
    public void deleteAllByApi(ExecutionContext executionContext, String apiId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.API, apiId, Optional.empty());
        allMetadata.forEach(referenceMetadataEntity -> this.delete(executionContext, referenceMetadataEntity.getKey(), MetadataReferenceType.API, apiId));
    }

    @Override
    public List<ApiMetadataEntity> create(ExecutionContext executionContext, List<ApiMetadataEntity> apiMetadata, String apiId) {
        if (apiMetadata == null || apiMetadata.isEmpty()) {
            return Collections.emptyList();
        }
        return apiMetadata.stream().map(data -> {
            NewApiMetadataEntity newMD = new NewApiMetadataEntity();
            newMD.setFormat(data.getFormat());
            newMD.setName(data.getName());
            newMD.setValue(data.getValue());
            newMD.setApiId(apiId);
            return newMD;
        }).map(newApiMetadataEntity -> this.create(executionContext, (NewApiMetadataEntity)newApiMetadataEntity)).collect(Collectors.toList());
    }

    @Override
    public ApiMetadataEntity create(ExecutionContext executionContext, NewApiMetadataEntity metadataEntity) {
        return this.convert(this.create(executionContext, (NewReferenceMetadataEntity)metadataEntity, MetadataReferenceType.API, metadataEntity.getApiId(), true), metadataEntity.getApiId());
    }

    @Override
    public ApiMetadataEntity update(ExecutionContext executionContext, UpdateApiMetadataEntity metadataEntity) {
        ApiMetadataEntity apiMetadataEntity = this.convert(this.update(executionContext, (UpdateReferenceMetadataEntity)metadataEntity, MetadataReferenceType.API, metadataEntity.getApiId(), true), metadataEntity.getApiId());
        GenericApiEntity genericApi = this.apiSearchService.findGenericById(executionContext, apiMetadataEntity.getApiId());
        GenericApiEntity genericApiWithMetadata = this.fetchMetadataForApi(executionContext, genericApi);
        this.searchEngineService.index(executionContext, (Indexable)genericApiWithMetadata, false);
        return apiMetadataEntity;
    }

    @Override
    protected void checkReferenceMetadataFormat(ExecutionContext executionContext, MetadataFormat format, String value, MetadataReferenceType referenceType, String referenceId) {
        GenericApiEntity genericApi = this.apiSearchService.findGenericById(executionContext, referenceId);
        this.metadataService.checkMetadataFormat(executionContext, format, value, referenceType, genericApi);
    }

    @Override
    public GenericApiEntity fetchMetadataForApi(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        List<ApiMetadataEntity> metadataList = this.findAllByApi(executionContext, genericApiEntity.getId());
        HashMap mapMetadata = new HashMap(metadataList.size());
        metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue() == null ? metadata.getDefaultValue() : metadata.getValue()));
        String decodedValue = this.notificationTemplateService.resolveInlineTemplateWithParam(executionContext.getOrganizationId(), genericApiEntity.getId(), new StringReader(((Object)mapMetadata).toString()), Collections.singletonMap("api", genericApiEntity));
        Map<String, Object> metadataDecoded = null;
        if (decodedValue != null) {
            metadataDecoded = Arrays.stream(decodedValue.substring(1, decodedValue.length() - 1).split(", ")).map(entry -> entry.split("=")).collect(Collectors.toMap(entry -> entry[0], entry -> ((String[])entry).length > 1 ? entry[1] : ""));
        }
        genericApiEntity.setMetadata(metadataDecoded);
        return genericApiEntity;
    }

    private ApiMetadataEntity convert(ReferenceMetadataEntity m, String apiId) {
        ApiMetadataEntity apiMetadataEntity = new ApiMetadataEntity();
        apiMetadataEntity.setKey(m.getKey());
        apiMetadataEntity.setName(m.getName());
        apiMetadataEntity.setFormat(m.getFormat());
        apiMetadataEntity.setValue(m.getValue());
        apiMetadataEntity.setDefaultValue(m.getDefaultValue());
        apiMetadataEntity.setApiId(apiId);
        return apiMetadataEntity;
    }
}

