/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.RatingAnswerRepository;
import io.gravitee.repository.management.api.RatingRepository;
import io.gravitee.repository.management.api.search.RatingCriteria;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Rating;
import io.gravitee.repository.management.model.RatingAnswer;
import io.gravitee.repository.management.model.RatingReferenceType;
import io.gravitee.rest.api.model.NewRatingAnswerEntity;
import io.gravitee.rest.api.model.NewRatingEntity;
import io.gravitee.rest.api.model.RatingAnswerEntity;
import io.gravitee.rest.api.model.RatingEntity;
import io.gravitee.rest.api.model.RatingSummaryEntity;
import io.gravitee.rest.api.model.UpdateRatingEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.RatingService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApiRatingUnavailableException;
import io.gravitee.rest.api.service.exceptions.RatingAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.RatingAnswerNotFoundException;
import io.gravitee.rest.api.service.exceptions.RatingNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RatingServiceImpl
extends AbstractService
implements RatingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RatingServiceImpl.class);
    @Lazy
    @Autowired
    private RatingRepository ratingRepository;
    @Lazy
    @Autowired
    private RatingAnswerRepository ratingAnswerRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private ApiSearchService apiSearchService;

    @Override
    public RatingEntity create(ExecutionContext executionContext, NewRatingEntity ratingEntity) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Optional ratingOptional = this.ratingRepository.findByReferenceIdAndReferenceTypeAndUser(ratingEntity.getApi(), RatingReferenceType.API, this.getAuthenticatedUsername());
            if (ratingOptional.isPresent()) {
                throw new RatingAlreadyExistsException(ratingEntity.getApi(), this.getAuthenticatedUsername());
            }
            Rating rating = this.ratingRepository.create(this.convert(ratingEntity));
            this.auditService.createApiAuditLog(executionContext, rating.getReferenceId(), null, (Audit.AuditEvent)Rating.RatingEvent.RATING_CREATED, rating.getCreatedAt(), null, rating);
            this.notifierService.trigger(executionContext, ApiHook.NEW_RATING, rating.getReferenceId(), new NotificationParamsBuilder().api(this.apiSearchService.findGenericById(executionContext, rating.getReferenceId())).build());
            return this.convert(executionContext, rating);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to create rating on api {}", (Object)ratingEntity.getApi(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to create rating on api " + ratingEntity.getApi(), ex);
        }
    }

    @Override
    public RatingEntity createAnswer(ExecutionContext executionContext, NewRatingAnswerEntity answerEntity) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Rating rating = this.findModelById(executionContext, answerEntity.getRatingId());
            RatingAnswer ratingAnswer = new RatingAnswer();
            ratingAnswer.setId(UuidString.generateRandom());
            ratingAnswer.setRating(answerEntity.getRatingId());
            ratingAnswer.setUser(this.getAuthenticatedUsername());
            ratingAnswer.setComment(answerEntity.getComment());
            ratingAnswer.setCreatedAt(new Date());
            this.ratingAnswerRepository.create(ratingAnswer);
            this.auditService.createApiAuditLog(executionContext, rating.getReferenceId(), null, (Audit.AuditEvent)RatingAnswer.RatingAnswerEvent.RATING_ANSWER_CREATED, ratingAnswer.getCreatedAt(), null, ratingAnswer);
            this.notifierService.trigger(executionContext, ApiHook.NEW_RATING_ANSWER, rating.getReferenceId(), new NotificationParamsBuilder().api(this.apiSearchService.findGenericById(executionContext, rating.getReferenceId())).build());
            return this.convert(executionContext, rating);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to create a rating answer on rating {}", (Object)answerEntity.getRatingId(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to create a rating answer on rating" + answerEntity.getRatingId(), ex);
        }
    }

    @Override
    public RatingEntity findById(ExecutionContext executionContext, String id) {
        return this.convert(executionContext, this.findModelById(executionContext, id));
    }

    @Override
    public RatingAnswerEntity findAnswerById(ExecutionContext executionContext, String answerId) {
        try {
            RatingAnswer ratingAnswer = (RatingAnswer)this.ratingAnswerRepository.findById(answerId).orElseThrow(() -> new RatingAnswerNotFoundException(answerId));
            return this.convert(executionContext, ratingAnswer);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find rating answer by answer id {}", (Object)answerId, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find rating answer by answer id " + answerId, ex);
        }
    }

    @NotNull
    private RatingAnswerEntity convert(ExecutionContext executionContext, RatingAnswer ratingAnswer) {
        RatingAnswerEntity ratingAnswerEntity = new RatingAnswerEntity();
        ratingAnswerEntity.setId(ratingAnswer.getId());
        ratingAnswerEntity.setRating(ratingAnswer.getRating());
        UserEntity userAnswer = this.userService.findById(executionContext, ratingAnswer.getUser());
        ratingAnswerEntity.setUser(userAnswer.getId());
        if (userAnswer.getFirstname() != null && userAnswer.getLastname() != null) {
            ratingAnswerEntity.setUserDisplayName(userAnswer.getFirstname() + " " + userAnswer.getLastname());
        } else {
            ratingAnswerEntity.setUserDisplayName(userAnswer.getEmail());
        }
        ratingAnswerEntity.setComment(ratingAnswer.getComment());
        ratingAnswerEntity.setCreatedAt(ratingAnswer.getCreatedAt());
        return ratingAnswerEntity;
    }

    @Override
    public Page<RatingEntity> findByApi(ExecutionContext executionContext, String api, Pageable pageable) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            return this.ratingRepository.findByReferenceIdAndReferenceTypePageable(api, RatingReferenceType.API, RatingServiceImpl.convert(pageable)).map(rating -> this.convert(executionContext, (Rating)rating));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find ratings for api {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find ratings for api " + api, ex);
        }
    }

    @Override
    public List<RatingEntity> findByApi(ExecutionContext executionContext, String api) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            List ratings = this.ratingRepository.findByReferenceIdAndReferenceType(api, RatingReferenceType.API);
            return ratings.stream().map(rating -> this.convert(executionContext, (Rating)rating)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find ratings for api {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find ratings for api " + api, ex);
        }
    }

    @Override
    public RatingSummaryEntity findSummaryByApi(ExecutionContext executionContext, String api) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            List ratings = this.ratingRepository.findByReferenceIdAndReferenceType(api, RatingReferenceType.API);
            RatingSummaryEntity ratingSummary = new RatingSummaryEntity();
            ratingSummary.setApi(api);
            ratingSummary.setNumberOfRatings(ratings.size());
            OptionalDouble optionalAvg = ratings.stream().mapToInt(Rating::getRate).average();
            if (optionalAvg.isPresent()) {
                ratingSummary.setAverageRate(Double.valueOf(optionalAvg.getAsDouble()));
            }
            ratingSummary.setNumberOfRatingsByRate(ratings.stream().collect(Collectors.groupingBy(Rating::getRate, Collectors.counting())));
            return ratingSummary;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find summary rating for api {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find summary rating for api " + api, ex);
        }
    }

    @Override
    public Set<String> findReferenceIdsOrderByRate(ExecutionContext executionContext, Collection<String> apis) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            return this.ratingRepository.findReferenceIdsOrderByRate(new RatingCriteria.Builder().referenceIds(apis).build());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to compute ranking for apis {}", apis, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to compute ranking for apis " + String.valueOf(apis), ex);
        }
    }

    @Override
    public RatingEntity findByApiForConnectedUser(ExecutionContext executionContext, String api) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Optional ratingOptional = this.ratingRepository.findByReferenceIdAndReferenceTypeAndUser(api, RatingReferenceType.API, this.getAuthenticatedUsername());
            if (ratingOptional.isPresent()) {
                return this.convert(executionContext, (Rating)ratingOptional.get());
            }
            return null;
        }
        catch (TechnicalException ex) {
            String message = "An error occurred while trying to find rating for api " + api + " and user " + this.getAuthenticatedUsername();
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public RatingEntity update(ExecutionContext executionContext, UpdateRatingEntity ratingEntity) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Rating rating = this.findModelById(executionContext, ratingEntity.getId());
            Rating oldRating = new Rating(rating);
            if (!rating.getReferenceId().equals(ratingEntity.getApi())) {
                throw new RatingNotFoundException(ratingEntity.getId(), ratingEntity.getApi());
            }
            Date now = new Date();
            rating.setUpdatedAt(now);
            rating.setRate(ratingEntity.getRate());
            if (StringUtils.isBlank((CharSequence)rating.getTitle())) {
                rating.setTitle(ratingEntity.getTitle());
            }
            if (StringUtils.isBlank((CharSequence)rating.getComment())) {
                rating.setComment(ratingEntity.getComment());
            }
            Rating updatedRating = this.ratingRepository.update(rating);
            this.auditService.createApiAuditLog(executionContext, rating.getReferenceId(), null, (Audit.AuditEvent)Rating.RatingEvent.RATING_UPDATED, updatedRating.getUpdatedAt(), oldRating, updatedRating);
            return this.convert(executionContext, updatedRating);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to update rating {}", (Object)ratingEntity.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to update rating " + ratingEntity.getId(), ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String id) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Rating rating = this.findModelById(executionContext, id);
            this.ratingRepository.delete(id);
            this.auditService.createApiAuditLog(executionContext, rating.getReferenceId(), null, (Audit.AuditEvent)Rating.RatingEvent.RATING_DELETED, new Date(), rating, null);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete rating {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete rating " + id, ex);
        }
    }

    @Override
    public void deleteAnswer(ExecutionContext executionContext, String ratingId, String answerId) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Rating rating = this.findModelById(executionContext, ratingId);
            this.ratingAnswerRepository.delete(answerId);
            this.auditService.createApiAuditLog(executionContext, rating.getReferenceId(), null, (Audit.AuditEvent)RatingAnswer.RatingAnswerEvent.RATING_ANSWER_DELETED, new Date(), rating, null);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete rating answer {}", (Object)answerId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete rating answer " + answerId, ex);
        }
    }

    @Override
    public boolean isEnabled(ExecutionContext executionContext) {
        return this.parameterService.findAsBoolean(executionContext, Key.PORTAL_RATING_ENABLED, ParameterReferenceType.ENVIRONMENT);
    }

    private Rating findModelById(ExecutionContext executionContext, String id) {
        if (!this.isEnabled(executionContext)) {
            throw new ApiRatingUnavailableException();
        }
        try {
            Optional ratingOptional = this.ratingRepository.findById(id);
            if (!ratingOptional.isPresent()) {
                throw new RatingNotFoundException(id);
            }
            return (Rating)ratingOptional.get();
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find a rating by id {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find a rating by id " + id, ex);
        }
    }

    private RatingEntity convert(ExecutionContext executionContext, Rating rating) {
        RatingEntity ratingEntity = new RatingEntity();
        UserEntity user = this.userService.findById(executionContext, rating.getUser());
        ratingEntity.setUser(user.getId());
        ratingEntity.setUserDisplayName(user.getDisplayName());
        ratingEntity.setId(rating.getId());
        ratingEntity.setApi(rating.getReferenceId());
        ratingEntity.setTitle(rating.getTitle());
        ratingEntity.setComment(rating.getComment());
        ratingEntity.setRate(rating.getRate());
        ratingEntity.setCreatedAt(rating.getCreatedAt());
        ratingEntity.setUpdatedAt(rating.getUpdatedAt());
        try {
            List ratingAnswers = this.ratingAnswerRepository.findByRating(rating.getId());
            if (ratingAnswers != null) {
                ratingEntity.setAnswers(ratingAnswers.stream().map(ratingAnswer -> this.convert(executionContext, (RatingAnswer)ratingAnswer)).sorted(Comparator.comparing(RatingAnswerEntity::getCreatedAt, Comparator.reverseOrder())).collect(Collectors.toList()));
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to find rating answers by rating id {}", (Object)rating.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to find rating answers by rating id " + rating.getId(), ex);
        }
        return ratingEntity;
    }

    private Rating convert(NewRatingEntity ratingEntity) {
        Rating rating = new Rating();
        rating.setId(UuidString.generateRandom());
        rating.setReferenceId(ratingEntity.getApi());
        rating.setReferenceType(RatingReferenceType.API);
        rating.setRate(ratingEntity.getRate());
        rating.setTitle(ratingEntity.getTitle());
        rating.setComment(ratingEntity.getComment());
        rating.setUser(this.getAuthenticatedUsername());
        Date now = new Date();
        rating.setCreatedAt(now);
        rating.setUpdatedAt(now);
        return rating;
    }
}

