/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewRoleEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateRoleEntity;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.ApplicationPermission;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.GroupPermission;
import io.gravitee.rest.api.model.permissions.IntegrationPermission;
import io.gravitee.rest.api.model.permissions.OrganizationPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.settings.ConsoleConfigEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.DefaultRoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.RoleAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.RoleDeletionForbiddenException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.RoleReservedNameException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RoleServiceImpl
extends AbstractService
implements RoleService {
    private final List<Map.Entry<String, NewRoleEntity>> initializeRoles = List.of(Map.entry("<ORGANIZATION> USER (default)", DefaultRoleEntityDefinition.DEFAULT_ROLE_ORGANIZATION_USER), Map.entry("<ENVIRONMENT> API_PUBLISHER", DefaultRoleEntityDefinition.ROLE_ENVIRONMENT_API_PUBLISHER), Map.entry("<ENVIRONMENT> FEDERATION_AGENT", DefaultRoleEntityDefinition.ROLE_ENVIRONMENT_FEDERATION_AGENT), Map.entry("<ENVIRONMENT> USER (default)", DefaultRoleEntityDefinition.DEFAULT_ROLE_ENVIRONMENT_USER), Map.entry("<API> USER (default)", DefaultRoleEntityDefinition.DEFAULT_ROLE_API_USER), Map.entry("<API> OWNER", DefaultRoleEntityDefinition.ROLE_API_OWNER), Map.entry("<API> REVIEWER", DefaultRoleEntityDefinition.ROLE_API_REVIEWER), Map.entry("<APPLICATION> USER (default)", DefaultRoleEntityDefinition.DEFAULT_ROLE_APPLICATION_USER), Map.entry("<APPLICATION> OWNER", DefaultRoleEntityDefinition.ROLE_APPLICATION_OWNER), Map.entry("<INTEGRATION> OWNER", DefaultRoleEntityDefinition.ROLE_INTEGRATION_OWNER), Map.entry("<INTEGRATION> USER", DefaultRoleEntityDefinition.ROLE_INTEGRATION_USER));
    private final Logger LOGGER = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Lazy
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ConfigService configService;
    private final Map<PrimaryOwner, RoleEntity> primaryOwnersByOrganization = new ConcurrentHashMap<PrimaryOwner, RoleEntity>();

    @Override
    public RoleEntity findById(String roleId) {
        return GraviteeContext.getCurrentRoles().computeIfAbsent(roleId, k -> {
            try {
                this.LOGGER.debug("Find Role by id");
                return this.roleRepository.findById(k).map(this::convert).orElseThrow(() -> new RoleNotFoundException((String)k));
            }
            catch (TechnicalException ex) {
                this.LOGGER.error("An error occurs while trying to find a role : {}", k, (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to find a role : " + k, ex);
            }
        });
    }

    @Override
    public Optional<RoleEntity> findByIdAndOrganizationId(String roleId, String organizationId) {
        try {
            return this.roleRepository.findByIdAndReferenceIdAndReferenceType(roleId, organizationId, RoleReferenceType.ORGANIZATION).map(this::convert);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find roles by id and organizationId", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find roles by id and organizationId", ex);
        }
    }

    @Override
    public List<RoleEntity> findAllByOrganization(String organizationId) {
        try {
            this.LOGGER.debug("Find all Roles");
            return this.roleRepository.findAllByReferenceIdAndReferenceType(organizationId, RoleReferenceType.ORGANIZATION).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all roles", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all roles", ex);
        }
    }

    @Override
    public RoleEntity create(ExecutionContext executionContext, NewRoleEntity roleEntity) {
        try {
            Role role = this.convert(executionContext, roleEntity);
            if (this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(role.getScope(), role.getName(), executionContext.getOrganizationId(), RoleReferenceType.ORGANIZATION).isPresent()) {
                throw new RoleAlreadyExistsException(role.getScope(), role.getName());
            }
            role.setId(UuidString.generateRandom());
            role.setCreatedAt(new Date());
            role.setUpdatedAt(role.getCreatedAt());
            role.setReferenceId(executionContext.getOrganizationId());
            role.setReferenceType(RoleReferenceType.ORGANIZATION);
            RoleEntity entity = this.convert(this.roleRepository.create(role));
            this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), Collections.singletonMap(Audit.AuditProperties.ROLE, String.valueOf(role.getScope()) + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_CREATED, role.getCreatedAt(), null, role);
            if (entity != null && entity.isDefaultRole()) {
                this.toggleDefaultRole(executionContext, roleEntity.getScope(), entity.getName());
            }
            return entity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create role {}", (Object)roleEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create role " + roleEntity.getName(), ex);
        }
    }

    @Override
    public RoleEntity update(ExecutionContext executionContext, UpdateRoleEntity roleEntity) {
        if (this.isReserved(executionContext, roleEntity.getScope(), roleEntity.getName())) {
            throw new RoleReservedNameException(roleEntity.getName());
        }
        io.gravitee.rest.api.model.permissions.RoleScope scope = roleEntity.getScope();
        try {
            Role role = this.roleRepository.findById(roleEntity.getId()).filter(r -> r.getReferenceType() == RoleReferenceType.ENVIRONMENT && r.getReferenceId().equalsIgnoreCase(executionContext.getEnvironmentId()) || r.getReferenceType() == RoleReferenceType.ORGANIZATION && r.getReferenceId().equalsIgnoreCase(executionContext.getOrganizationId())).orElseThrow(() -> new RoleNotFoundException(roleEntity.getId()));
            Role updatedRole = this.convert(executionContext, roleEntity);
            updatedRole.setCreatedAt(role.getCreatedAt());
            updatedRole.setReferenceId(role.getReferenceId());
            updatedRole.setReferenceType(role.getReferenceType());
            RoleEntity entity = this.convert(this.roleRepository.update(updatedRole));
            this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), Collections.singletonMap(Audit.AuditProperties.ROLE, String.valueOf(role.getScope()) + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, updatedRole.getUpdatedAt(), role, updatedRole);
            if (entity != null && entity.isDefaultRole()) {
                this.toggleDefaultRole(executionContext, scope, entity.getName());
            }
            return entity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update role {}", (Object)roleEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update role " + roleEntity.getName(), ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String roleId) {
        try {
            Role role = (Role)this.roleRepository.findById(roleId).orElseThrow(() -> new RoleNotFoundException(roleId));
            io.gravitee.rest.api.model.permissions.RoleScope scope = this.convert(role.getScope());
            if (role.isDefaultRole() || role.isSystem()) {
                throw new RoleDeletionForbiddenException(scope, role.getName());
            }
            List<RoleEntity> defaultRoleByScopes = this.findDefaultRoleByScopes(executionContext.getOrganizationId(), scope);
            if (defaultRoleByScopes.isEmpty()) {
                throw new DefaultRoleNotFoundException(new io.gravitee.rest.api.model.permissions.RoleScope[0]);
            }
            this.membershipService.removeRoleUsage(roleId, defaultRoleByScopes.get(0).getId());
            this.roleRepository.delete(roleId);
            this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), Collections.singletonMap(Audit.AuditProperties.ROLE, String.valueOf(scope) + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_DELETED, role.getUpdatedAt(), role, null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete role {}", (Object)roleId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete role " + roleId, ex);
        }
    }

    @Override
    public List<RoleEntity> findByScope(io.gravitee.rest.api.model.permissions.RoleScope scope, String organizationId) {
        try {
            this.LOGGER.debug("Find Roles by scope");
            return this.roleRepository.findByScopeAndReferenceIdAndReferenceType(this.convert(scope), organizationId, RoleReferenceType.ORGANIZATION).stream().map(this::convert).sorted(Comparator.comparing(RoleEntity::getName)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find roles by scope", ex);
        }
    }

    @Override
    public Optional<RoleEntity> findByScopeAndName(io.gravitee.rest.api.model.permissions.RoleScope scope, String name, String organizationId) {
        try {
            this.LOGGER.debug("Find Roles by scope and name");
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(this.convert(scope), name, organizationId, RoleReferenceType.ORGANIZATION).map(this::convert);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find roles by scope", ex);
        }
    }

    @Override
    public List<RoleEntity> findDefaultRoleByScopes(String organizationId, io.gravitee.rest.api.model.permissions.RoleScope ... scopes) {
        try {
            this.LOGGER.debug("Find default Roles by scope");
            ArrayList<RoleEntity> roles = new ArrayList<RoleEntity>();
            for (io.gravitee.rest.api.model.permissions.RoleScope scope : scopes) {
                roles.addAll(this.roleRepository.findByScopeAndReferenceIdAndReferenceType(this.convert(scope), organizationId, RoleReferenceType.ORGANIZATION).stream().filter(Role::isDefaultRole).map(this::convert).toList());
            }
            return roles;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find default roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find default roles by scope", ex);
        }
    }

    @Override
    public boolean hasPermission(Map<String, char[]> userPermissions, Permission permission, RolePermissionAction[] acls) {
        boolean hasPermission = false;
        if (userPermissions != null) {
            Iterator<Map.Entry<String, char[]>> it = userPermissions.entrySet().iterator();
            while (it.hasNext() && !hasPermission) {
                Map.Entry<String, char[]> entry = it.next();
                if (!permission.getName().equals(entry.getKey())) continue;
                String crud = Arrays.toString(entry.getValue());
                for (RolePermissionAction perm : acls) {
                    if (crud.indexOf(perm.getId()) == -1) continue;
                    hasPermission = true;
                }
            }
        }
        return hasPermission;
    }

    private void toggleDefaultRole(ExecutionContext executionContext, io.gravitee.rest.api.model.permissions.RoleScope scope, String newDefaultRoleName) throws TechnicalException {
        List<Role> roles = this.roleRepository.findByScopeAndReferenceIdAndReferenceType(this.convert(scope), executionContext.getOrganizationId(), RoleReferenceType.ORGANIZATION).stream().filter(Role::isDefaultRole).toList();
        for (Role role : roles) {
            if (role.getName().equals(newDefaultRoleName)) continue;
            Role previousRole = new Role(role);
            role.setDefaultRole(false);
            role.setUpdatedAt(new Date());
            this.roleRepository.update(role);
            this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), Collections.singletonMap(Audit.AuditProperties.ROLE, String.valueOf(role.getScope()) + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, role.getUpdatedAt(), previousRole, role);
        }
    }

    private Role convert(ExecutionContext executionContext, NewRoleEntity roleEntity) {
        Role role = new Role();
        role.setName(this.generateId(executionContext, roleEntity.getScope(), roleEntity.getName()));
        role.setDescription(roleEntity.getDescription());
        role.setScope(this.convert(roleEntity.getScope()));
        role.setDefaultRole(roleEntity.isDefaultRole());
        role.setPermissions(this.convertPermissions(roleEntity.getScope(), roleEntity.getPermissions()));
        role.setCreatedAt(new Date());
        role.setUpdatedAt(role.getCreatedAt());
        return role;
    }

    private Role convert(ExecutionContext executionContext, UpdateRoleEntity roleEntity) {
        if (roleEntity == null) {
            return null;
        }
        Role role = new Role();
        role.setName(this.generateId(executionContext, roleEntity.getScope(), roleEntity.getName()));
        role.setId(roleEntity.getId());
        role.setDescription(roleEntity.getDescription());
        role.setScope(this.convert(roleEntity.getScope()));
        role.setDefaultRole(roleEntity.isDefaultRole());
        role.setPermissions(this.convertPermissions(roleEntity.getScope(), roleEntity.getPermissions()));
        role.setUpdatedAt(new Date());
        return role;
    }

    private RoleEntity convert(Role role) {
        if (role == null) {
            return null;
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(role.getId());
        roleEntity.setName(role.getName());
        roleEntity.setDescription(role.getDescription());
        roleEntity.setScope(this.convert(role.getScope()));
        roleEntity.setDefaultRole(role.isDefaultRole());
        roleEntity.setSystem(role.isSystem());
        roleEntity.setPermissions(this.convertPermissions(roleEntity.getScope(), role.getPermissions()));
        return roleEntity;
    }

    private int[] convertPermissions(io.gravitee.rest.api.model.permissions.RoleScope scope, Map<String, char[]> perms) {
        if (perms == null || perms.isEmpty()) {
            return new int[0];
        }
        int[] result = new int[perms.size()];
        int idx = 0;
        for (Map.Entry<String, char[]> entry : perms.entrySet()) {
            int perm = 0;
            for (char c : entry.getValue()) {
                perm += RolePermissionAction.findById((char)c).getMask();
            }
            result[idx++] = Permission.findByScopeAndName((io.gravitee.rest.api.model.permissions.RoleScope)scope, (String)entry.getKey()).getMask() + perm;
        }
        return result;
    }

    private Map<String, char[]> convertPermissions(io.gravitee.rest.api.model.permissions.RoleScope scope, int[] perms) {
        if (perms == null) {
            return Collections.emptyMap();
        }
        HashMap<String, char[]> result = new HashMap<String, char[]>();
        Stream.of(Permission.findByScope((io.gravitee.rest.api.model.permissions.RoleScope)scope)).forEach(perm -> {
            for (int action : perms) {
                if (action / 100 != perm.getMask() / 100) continue;
                ArrayList<Character> crud = new ArrayList<Character>();
                for (RolePermissionAction rolePermissionAction : RolePermissionAction.values()) {
                    if ((action - perm.getMask() & rolePermissionAction.getMask()) == 0) continue;
                    crud.add(Character.valueOf(rolePermissionAction.getId()));
                }
                result.put(perm.getName(), ArrayUtils.toPrimitive((Character[])crud.toArray(new Character[0])));
            }
        });
        return result;
    }

    private RoleScope convert(io.gravitee.rest.api.model.permissions.RoleScope scope) {
        return scope == null ? null : RoleScope.valueOf((String)scope.name());
    }

    private io.gravitee.rest.api.model.permissions.RoleScope convert(RoleScope scope) {
        return scope == null ? null : io.gravitee.rest.api.model.permissions.RoleScope.valueOf((String)scope.name());
    }

    private String generateId(ExecutionContext executionContext, io.gravitee.rest.api.model.permissions.RoleScope scope, String name) {
        String id = name.trim().toUpperCase().replaceAll(" +", " ").replaceAll(" ", "_").replaceAll("[^\\w\\s]", "_").replaceAll("-+", "_");
        if (this.isReserved(executionContext, scope, id)) {
            throw new RoleReservedNameException(id);
        }
        return id;
    }

    private boolean isReserved(ExecutionContext executionContext, io.gravitee.rest.api.model.permissions.RoleScope scope, String name) {
        ConsoleConfigEntity config = this.configService.getConsoleConfig(executionContext);
        if (config.getManagement().getSystemRoleEdition().isEnabled()) {
            return scope == io.gravitee.rest.api.model.permissions.RoleScope.ORGANIZATION && SystemRole.ADMIN.name().equals(name);
        }
        return this.isSystemRole(name);
    }

    private boolean isSystemRole(String roleName) {
        for (SystemRole systemRole : SystemRole.values()) {
            if (!systemRole.name().equals(roleName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(ExecutionContext executionContext, String organizationId) {
        this.initializeRoles.forEach(entry -> {
            this.LOGGER.info("     - {}", entry.getKey());
            this.create(executionContext, (NewRoleEntity)entry.getValue());
        });
    }

    @Override
    public void createOrUpdateSystemRoles(ExecutionContext executionContext, String organizationId) {
        try {
            this.createOrUpdateSystemRole(executionContext, SystemRole.ADMIN, io.gravitee.rest.api.model.permissions.RoleScope.ORGANIZATION, (Permission[])OrganizationPermission.values(), organizationId);
            this.createOrUpdateSystemRole(executionContext, SystemRole.ADMIN, io.gravitee.rest.api.model.permissions.RoleScope.ENVIRONMENT, (Permission[])EnvironmentPermission.values(), organizationId);
            this.createOrUpdateSystemRole(executionContext, SystemRole.PRIMARY_OWNER, io.gravitee.rest.api.model.permissions.RoleScope.API, (Permission[])Arrays.stream(ApiPermission.values()).filter(permission -> !ApiPermission.REVIEWS.equals(permission)).toArray(Permission[]::new), organizationId);
            this.createOrUpdateSystemRole(executionContext, SystemRole.PRIMARY_OWNER, io.gravitee.rest.api.model.permissions.RoleScope.APPLICATION, (Permission[])ApplicationPermission.values(), organizationId);
            this.createOrUpdateSystemRole(executionContext, SystemRole.PRIMARY_OWNER, io.gravitee.rest.api.model.permissions.RoleScope.INTEGRATION, (Permission[])IntegrationPermission.values(), organizationId);
            this.createOrUpdateSystemRole(executionContext, SystemRole.ADMIN, io.gravitee.rest.api.model.permissions.RoleScope.GROUP, (Permission[])GroupPermission.values(), organizationId);
        }
        catch (TechnicalManagementException ex) {
            this.LOGGER.error("An error occurs while trying to create admin roles", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create admin roles ", ex);
        }
    }

    @Override
    public io.gravitee.rest.api.model.permissions.RoleScope findScopeByMembershipReferenceType(MembershipReferenceType type) {
        return type.findScope();
    }

    @Override
    public RoleEntity findPrimaryOwnerRoleByOrganization(String organizationId, io.gravitee.rest.api.model.permissions.RoleScope roleScope) {
        return this.primaryOwnersByOrganization.computeIfAbsent(new PrimaryOwner(organizationId, roleScope), s -> this.findByScopeAndName(s.roleScope(), SystemRole.PRIMARY_OWNER.name(), s.organisation()).orElse(null));
    }

    @Override
    public void createOrUpdateSystemRole(ExecutionContext executionContext, SystemRole roleName, io.gravitee.rest.api.model.permissions.RoleScope roleScope, Permission[] permissions, String organizationId) {
        try {
            Role systemRole = this.createSystemRoleWithoutPermissions(roleName.name(), roleScope, new Date());
            HashMap<String, char[]> perms = new HashMap<String, char[]>();
            for (Permission perm : permissions) {
                perms.put(perm.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
            }
            systemRole.setPermissions(this.convertPermissions(roleScope, perms));
            systemRole.setReferenceId(organizationId);
            systemRole.setReferenceType(RoleReferenceType.ORGANIZATION);
            Optional existingRole = this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(systemRole.getScope(), systemRole.getName(), organizationId, RoleReferenceType.ORGANIZATION);
            if (existingRole.isPresent() && this.permissionsAreDifferent((Role)existingRole.get(), systemRole)) {
                systemRole.setId(((Role)existingRole.get()).getId());
                systemRole.setUpdatedAt(new Date());
                this.roleRepository.update(systemRole);
                this.auditService.createOrganizationAuditLog(executionContext, organizationId, Collections.singletonMap(Audit.AuditProperties.ROLE, String.valueOf(systemRole.getScope()) + ":" + systemRole.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, systemRole.getCreatedAt(), existingRole.get(), systemRole);
            } else if (existingRole.isEmpty()) {
                this.roleRepository.create(systemRole);
                this.auditService.createOrganizationAuditLog(executionContext, organizationId, Collections.singletonMap(Audit.AuditProperties.ROLE, String.valueOf(systemRole.getScope()) + ":" + systemRole.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_CREATED, systemRole.getCreatedAt(), null, systemRole);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} {} roles", new Object[]{roleName.name(), roleScope.name(), ex});
            throw new TechnicalManagementException("An error occurs while trying to create " + roleName.name() + " " + roleScope.name() + " roles ", ex);
        }
    }

    private Role createSystemRoleWithoutPermissions(String name, io.gravitee.rest.api.model.permissions.RoleScope scope, Date date) {
        this.LOGGER.info("      - <" + String.valueOf(scope) + "> " + name + " (system)");
        Role systemRole = new Role();
        systemRole.setId(UuidString.generateRandom());
        systemRole.setName(name);
        systemRole.setDescription("System Role. Created by Gravitee.io");
        systemRole.setDefaultRole(false);
        systemRole.setSystem(true);
        systemRole.setScope(this.convert(scope));
        systemRole.setCreatedAt(date);
        systemRole.setUpdatedAt(date);
        return systemRole;
    }

    private boolean permissionsAreDifferent(Role role1, Role role2) {
        return Arrays.stream(role1.getPermissions()).reduce(Math::addExact).orElse(0) != Arrays.stream(role2.getPermissions()).reduce(Math::addExact).orElse(0);
    }

    private record PrimaryOwner(String organisation, io.gravitee.rest.api.model.permissions.RoleScope roleScope) {
    }
}

