/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.apim.core.api.domain_service.VerifyApiPathDomainService;
import io.gravitee.apim.core.api.model.Path;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.category.domain_service.ValidateCategoryIdsDomainService;
import io.gravitee.apim.core.documentation.domain_service.ValidatePagesDomainService;
import io.gravitee.apim.core.group.domain_service.ValidateGroupsDomainService;
import io.gravitee.apim.core.member.domain_service.ValidateCRDMembersDomainService;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.apim.infra.adapter.ApiCRDEntityAdapter;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.api.ApiCRDEntity;
import io.gravitee.rest.api.model.api.ApiValidationResult;
import io.gravitee.rest.api.service.ApiValidationService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.AbstractService;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="apiV2ValidationService")
public class ApiValidationServiceImpl
extends AbstractService
implements ApiValidationService {
    @Inject
    private ValidateCategoryIdsDomainService validateCategoryIdsDomainService;
    @Inject
    private ValidateCRDMembersDomainService validateCRDMembersDomainService;
    @Inject
    private ValidateGroupsDomainService validateGroupsDomainService;
    @Inject
    private VerifyApiPathDomainService apiPathValidator;
    @Inject
    private ValidatePagesDomainService pagesValidator;

    @Override
    public ApiValidationResult<ApiCRDEntity> validateAndSanitizeApiDefinitionCRD(ExecutionContext executionContext, ApiCRDEntity api) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        UserDetails authenticatedUser = this.getAuthenticatedUser();
        AuditInfo auditInfo = AuditInfo.builder().organizationId(executionContext.getOrganizationId()).environmentId(executionContext.getEnvironmentId()).actor(AuditActor.builder().userId(authenticatedUser.getUsername()).userSource(authenticatedUser.getSource()).userSourceId(authenticatedUser.getSourceId()).build()).build();
        this.apiPathValidator.validateAndSanitize(new VerifyApiPathDomainService.Input(executionContext.getEnvironmentId(), api.getId(), ApiValidationServiceImpl.extractPaths(api))).peek(sanitized -> api.getProxy().setVirtualHosts(ApiValidationServiceImpl.mapPaths(sanitized.paths())), errors::addAll);
        this.validateCategoryIdsDomainService.validateAndSanitize(new ValidateCategoryIdsDomainService.Input(executionContext.getEnvironmentId(), api.getCategories())).peek(sanitized -> api.setCategories(sanitized.idOrKeys()), errors::addAll);
        this.validateCRDMembersDomainService.validateAndSanitize(new ValidateCRDMembersDomainService.Input(auditInfo, MembershipReferenceType.API, ApiCRDEntityAdapter.INSTANCE.toMemberCRDs(api.getMembers()))).peek(sanitized -> api.setMembers(ApiCRDEntityAdapter.INSTANCE.toApiCRDMembers(sanitized.members())), errors::addAll);
        this.validateGroupsDomainService.validateAndSanitize(new ValidateGroupsDomainService.Input(executionContext.getEnvironmentId(), api.getGroups(), api.getGraviteeDefinitionVersion())).peek(sanitized -> api.setGroups(sanitized.groups()), errors::addAll);
        this.pagesValidator.validateAndSanitize(new ValidatePagesDomainService.Input(auditInfo, api.getId(), ApiCRDEntityAdapter.INSTANCE.toCoreApiCRDPages(api.getPagesMap()))).peek(sanitized -> api.setPages(ApiCRDEntityAdapter.INSTANCE.toRestApiCRDPages(sanitized.pages())), errors::addAll);
        return ApiValidationServiceImpl.convertToValidationResult(api, errors);
    }

    @NotNull
    private static ApiValidationResult<ApiCRDEntity> convertToValidationResult(ApiCRDEntity api, List<Validator.Error> errors) {
        ArrayList<String> severe = new ArrayList<String>();
        ArrayList<String> warning = new ArrayList<String>();
        for (Validator.Error error : errors) {
            if (error.isSevere()) {
                severe.add(error.getMessage());
                continue;
            }
            warning.add(error.getMessage());
        }
        return new ApiValidationResult((Object)api, severe, warning);
    }

    private static List<Path> extractPaths(ApiCRDEntity api) {
        return api.getProxy().getVirtualHosts().stream().map(vh -> Path.builder().host(vh.getHost()).path(vh.getPath()).overrideAccess(vh.isOverrideEntrypoint()).build()).toList();
    }

    private static List<VirtualHost> mapPaths(List<Path> paths) {
        return paths.stream().map(path -> new VirtualHost(path.getHost(), path.getPath(), path.isOverrideAccess())).toList();
    }
}

