/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionConsumerStatusNotUpdatableException
extends AbstractManagementException {
    private final Subscription subscription;
    private final Cause cause;

    public SubscriptionConsumerStatusNotUpdatableException(Subscription subscription, Cause cause) {
        this.subscription = subscription;
        this.cause = cause;
    }

    @Override
    public String getMessage() {
        String message = "Subscription [" + this.subscription.getId() + "] consumer status cannot be updated because ";
        switch (this.cause.ordinal()) {
            case 0: {
                return message + "API definition version should be V4";
            }
            case 1: {
                return message + "API should contain a listener of type SUBSCRIPTION";
            }
        }
        return "";
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getTechnicalCode() {
        return "subscription.consumerStatusNotUpdatable";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("subscription", this.subscription.getId());
        parameters.put("status", this.subscription.getStatus().name());
        parameters.put("consumerStatus", this.subscription.getConsumerStatus().name());
        return parameters;
    }

    public static enum Cause {
        DEFINITION_NOT_V4,
        NO_SUBSCRIPTION_LISTENER;

    }
}

