/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.notification.crud_service.NotificationConfigCrudService;
import io.gravitee.apim.core.notification.model.config.NotificationConfig;
import io.gravitee.apim.core.parameters.model.ParameterContext;
import io.gravitee.apim.core.parameters.query_service.ParametersQueryService;
import io.gravitee.apim.core.workflow.crud_service.WorkflowCrudService;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import lombok.Generated;

@DomainService
public class CreateApiDomainService {
    private final ApiCrudService apiCrudService;
    private final AuditDomainService auditService;
    private final ApiIndexerDomainService apiIndexerDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final FlowCrudService flowCrudService;
    private final NotificationConfigCrudService notificationConfigCrudService;
    private final ParametersQueryService parametersQueryService;
    private final WorkflowCrudService workflowCrudService;

    public ApiWithFlows create(Api api, PrimaryOwnerEntity primaryOwner, AuditInfo auditInfo, UnaryOperator<Api> sanitizer) {
        return this.create(api, primaryOwner, auditInfo, sanitizer, ApiIndexerDomainService.oneShotIndexation(auditInfo));
    }

    public ApiWithFlows create(Api api, PrimaryOwnerEntity primaryOwner, AuditInfo auditInfo, UnaryOperator<Api> sanitizer, ApiIndexerDomainService.Context indexContext) {
        Api sanitized = (Api)sanitizer.apply(api);
        Api created = this.apiCrudService.create(sanitized);
        this.createAuditLog(created, auditInfo);
        this.apiPrimaryOwnerDomainService.createApiPrimaryOwnerMembership(created.getId(), primaryOwner, auditInfo);
        this.createDefaultMailNotification(created);
        this.createDefaultMetadata(created, auditInfo);
        List<? extends AbstractFlow> createdFlows = this.saveApiFlows(api);
        if (this.isApiReviewEnabled(created, auditInfo.organizationId(), auditInfo.environmentId())) {
            this.workflowCrudService.create(Workflow.newApiReviewWorkflow(api.getId(), auditInfo.actor().userId()));
        }
        this.apiIndexerDomainService.index(indexContext, created, primaryOwner);
        return new ApiWithFlows(created, createdFlows);
    }

    private void createAuditLog(Api created, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(created.getId()).event(ApiAuditEvent.API_CREATED).actor(auditInfo.actor()).newValue(created).createdAt(created.getCreatedAt()).properties(Collections.emptyMap()).build());
    }

    private void createDefaultMailNotification(Api api) {
        switch (api.getDefinitionVersion()) {
            case V4: {
                this.notificationConfigCrudService.create(NotificationConfig.defaultMailNotificationConfigFor(api.getId()));
                break;
            }
        }
    }

    private void createDefaultMetadata(Api api, AuditInfo auditInfo) {
        switch (api.getDefinitionVersion()) {
            case V4: {
                this.apiMetadataDomainService.createDefaultApiMetadata(api.getId(), auditInfo);
                break;
            }
        }
    }

    private List<? extends AbstractFlow> saveApiFlows(Api api) {
        return switch (api.getDefinitionVersion()) {
            default -> throw new MatchException(null, null);
            case DefinitionVersion.V4 -> {
                switch (api.getType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case PROXY: 
                    case MESSAGE: {
                        yield this.flowCrudService.saveApiFlows(api.getId(), api.getApiDefinitionHttpV4().getFlows());
                    }
                    case NATIVE: 
                }
                yield this.flowCrudService.saveNativeApiFlows(api.getId(), api.getApiDefinitionNativeV4().getFlows());
            }
            case DefinitionVersion.V1, DefinitionVersion.V2, DefinitionVersion.FEDERATED -> null;
        };
    }

    private boolean isApiReviewEnabled(Api api, String organizationId, String environmentId) {
        return switch (api.getDefinitionVersion()) {
            default -> throw new MatchException(null, null);
            case DefinitionVersion.V4, DefinitionVersion.V1, DefinitionVersion.V2 -> this.parametersQueryService.findAsBoolean(Key.API_REVIEW_ENABLED, new ParameterContext(environmentId, organizationId, ParameterReferenceType.ENVIRONMENT));
            case DefinitionVersion.FEDERATED -> false;
        };
    }

    @Generated
    public CreateApiDomainService(ApiCrudService apiCrudService, AuditDomainService auditService, ApiIndexerDomainService apiIndexerDomainService, ApiMetadataDomainService apiMetadataDomainService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, FlowCrudService flowCrudService, NotificationConfigCrudService notificationConfigCrudService, ParametersQueryService parametersQueryService, WorkflowCrudService workflowCrudService) {
        this.apiCrudService = apiCrudService;
        this.auditService = auditService;
        this.apiIndexerDomainService = apiIndexerDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.flowCrudService = flowCrudService;
        this.notificationConfigCrudService = notificationConfigCrudService;
        this.parametersQueryService = parametersQueryService;
        this.workflowCrudService = workflowCrudService;
    }
}

