/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notifiers.impl;

import io.gravitee.apim.core.notification.model.ApiNotificationTemplateData;
import io.gravitee.apim.core.notification.model.ApplicationNotificationTemplateData;
import io.gravitee.apim.core.notification.model.PlanNotificationTemplateData;
import io.gravitee.apim.core.notification.model.PrimaryOwnerNotificationTemplateData;
import io.gravitee.apim.core.notification.model.SubscriptionNotificationTemplateData;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.BasePlanEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiModel;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notifiers.WebNotifierService;
import io.gravitee.rest.api.service.notifiers.WebhookNotifierService;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebhookNotifierServiceImpl
implements WebhookNotifierService {
    private final Logger LOGGER = LoggerFactory.getLogger(WebhookNotifierServiceImpl.class);
    @Autowired
    WebNotifierService webNotifierService;

    @Override
    public void trigger(Hook hook, GenericNotificationConfig genericNotificationConfig, Map<String, Object> params) {
        String body = this.toJson(hook, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Gravitee-Event", hook.name());
        headers.put("X-Gravitee-Event-Scope", hook.getScope().name());
        this.webNotifierService.request(HttpMethod.POST, genericNotificationConfig.getConfig(), headers, body, genericNotificationConfig.isUseSystemProxy());
    }

    private String toJson(Hook hook, Map<String, Object> params) {
        JsonObject content = new JsonObject();
        content.put("event", (Object)hook.name());
        content.put("scope", (Object)hook.getScope().name());
        this.addJsonObject(params, "api", content, "api", GenericApiModel.class, GenericApiEntity.class, ApiNotificationTemplateData.class);
        this.addJsonObject(params, "application", content, "application", ApplicationEntity.class, ApplicationNotificationTemplateData.class);
        this.addJsonObject(params, "owner", content, "owner", PrimaryOwnerEntity.class, PrimaryOwnerNotificationTemplateData.class);
        this.addJsonObject(params, "plan", content, "plan", io.gravitee.rest.api.model.PlanEntity.class, PlanEntity.class, PlanNotificationTemplateData.class, BasePlanEntity.class);
        this.addJsonObject(params, "subscription", content, "subscription", SubscriptionEntity.class, SubscriptionNotificationTemplateData.class);
        return content.encode();
    }

    private void addJsonObject(Map<String, Object> params, String paramKey, JsonObject content, String jsonKey, Class<?> ... dataTypes) {
        if (params.containsKey(paramKey)) {
            Object object = params.get(paramKey);
            JsonObject jsonObject = new JsonObject();
            for (Class<?> dataType : dataTypes) {
                if (!dataType.isInstance(object)) continue;
                this.populateJson(jsonObject, object, dataType);
                content.put(jsonKey, (Object)jsonObject);
                return;
            }
            throw new IllegalArgumentException("Unsupported type for " + jsonKey + ": " + object.getClass().getName());
        }
    }

    private void populateJson(JsonObject jsonObject, Object object, Class<?> dataType) {
        if (dataType == GenericApiModel.class) {
            GenericApiModel model = (GenericApiModel)object;
            jsonObject.put("id", (Object)model.getId());
            jsonObject.put("name", (Object)model.getName());
            jsonObject.put("version", (Object)model.getApiVersion());
        } else if (dataType == GenericApiEntity.class) {
            GenericApiEntity entity = (GenericApiEntity)object;
            jsonObject.put("id", (Object)entity.getId());
            jsonObject.put("name", (Object)entity.getName());
            jsonObject.put("version", (Object)entity.getApiVersion());
        } else if (dataType == ApiNotificationTemplateData.class) {
            ApiNotificationTemplateData data = (ApiNotificationTemplateData)object;
            jsonObject.put("id", (Object)data.getId());
            jsonObject.put("name", (Object)data.getName());
            jsonObject.put("version", (Object)data.getVersion());
        } else if (dataType == ApplicationEntity.class) {
            ApplicationEntity application = (ApplicationEntity)object;
            jsonObject.put("id", (Object)application.getId());
            jsonObject.put("name", (Object)application.getName());
        } else if (dataType == ApplicationNotificationTemplateData.class) {
            ApplicationNotificationTemplateData notificationData = (ApplicationNotificationTemplateData)object;
            jsonObject.put("id", (Object)notificationData.getId());
            jsonObject.put("name", (Object)notificationData.getName());
        } else if (dataType == PrimaryOwnerEntity.class) {
            PrimaryOwnerEntity owner = (PrimaryOwnerEntity)object;
            jsonObject.put("id", (Object)owner.getId());
            jsonObject.put("username", (Object)owner.getDisplayName());
        } else if (dataType == PrimaryOwnerNotificationTemplateData.class) {
            PrimaryOwnerNotificationTemplateData notificationData = (PrimaryOwnerNotificationTemplateData)object;
            jsonObject.put("id", (Object)notificationData.getId());
            jsonObject.put("username", (Object)notificationData.getDisplayName());
        } else if (dataType == io.gravitee.rest.api.model.PlanEntity.class) {
            io.gravitee.rest.api.model.PlanEntity plan = (io.gravitee.rest.api.model.PlanEntity)object;
            jsonObject.put("id", (Object)plan.getId());
            jsonObject.put("name", (Object)plan.getName());
            jsonObject.put("security", (Object)plan.getSecurity());
        } else if (dataType == PlanEntity.class) {
            PlanEntity plan = (PlanEntity)object;
            jsonObject.put("id", (Object)plan.getId());
            jsonObject.put("name", (Object)plan.getName());
            jsonObject.put("security", (Object)plan.getSecurity());
        } else if (dataType == BasePlanEntity.class) {
            BasePlanEntity plan = (BasePlanEntity)object;
            jsonObject.put("id", (Object)plan.getId());
            jsonObject.put("name", (Object)plan.getName());
            jsonObject.put("security", (Object)plan.getSecurity());
        } else if (dataType == PlanNotificationTemplateData.class) {
            PlanNotificationTemplateData notificationData = (PlanNotificationTemplateData)object;
            jsonObject.put("id", (Object)notificationData.getId());
            jsonObject.put("name", (Object)notificationData.getName());
            jsonObject.put("security", (Object)notificationData.getSecurity());
        } else if (dataType == SubscriptionEntity.class) {
            SubscriptionEntity subscription = (SubscriptionEntity)object;
            jsonObject.put("id", (Object)subscription.getId());
            jsonObject.put("status", (Object)subscription.getStatus());
        } else if (dataType == SubscriptionNotificationTemplateData.class) {
            SubscriptionNotificationTemplateData notificationData = (SubscriptionNotificationTemplateData)object;
            jsonObject.put("id", (Object)notificationData.getId());
            jsonObject.put("status", (Object)notificationData.getStatus());
        }
    }
}

