/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.import_definition.ApiMember;
import io.gravitee.apim.core.api.model.import_definition.ApiMemberRole;
import io.gravitee.apim.core.member.model.Member;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.infra.adapter.MemberAdapter;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.RoleEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemberAdapterImpl
implements MemberAdapter {
    @Override
    public ApiMember toApiMember(Membership member) {
        if (member == null) {
            return null;
        }
        ApiMember.ApiMemberBuilder apiMember = ApiMember.builder();
        apiMember.id(member.getId());
        return apiMember.build();
    }

    @Override
    public MemberEntity toEntity(ApiMember member) {
        if (member == null) {
            return null;
        }
        MemberEntity.MemberEntityBuilder memberEntity = MemberEntity.builder();
        memberEntity.id(member.getId());
        memberEntity.displayName(member.getDisplayName());
        memberEntity.type(member.getType());
        memberEntity.roles(this.toEntities(member.getRoles()));
        return memberEntity.build();
    }

    @Override
    public Set<MemberEntity> toEntities(Set<ApiMember> members) {
        if (members == null) {
            return null;
        }
        LinkedHashSet<MemberEntity> set = new LinkedHashSet<MemberEntity>(Math.max((int)((float)members.size() / 0.75f) + 1, 16));
        for (ApiMember apiMember : members) {
            set.add(this.toEntity(apiMember));
        }
        return set;
    }

    @Override
    public RoleEntity toEntity(ApiMemberRole role) {
        if (role == null) {
            return null;
        }
        RoleEntity.RoleEntityBuilder roleEntity = RoleEntity.builder();
        roleEntity.name(role.getName());
        roleEntity.scope(role.getScope());
        return roleEntity.build();
    }

    @Override
    public List<RoleEntity> toEntities(List<ApiMemberRole> roles) {
        if (roles == null) {
            return null;
        }
        ArrayList<RoleEntity> list = new ArrayList<RoleEntity>(roles.size());
        for (ApiMemberRole apiMemberRole : roles) {
            list.add(this.toEntity(apiMemberRole));
        }
        return list;
    }

    @Override
    public Member toMember(MemberEntity member) {
        if (member == null) {
            return null;
        }
        Member member1 = new Member();
        member1.setId(member.getId());
        member1.setDisplayName(member.getDisplayName());
        member1.setEmail(member.getEmail());
        member1.setType(member.getType());
        member1.setReferenceType(member.getReferenceType());
        member1.setReferenceId(member.getReferenceId());
        member1.setRoles(this.roleEntityListToRoleList(member.getRoles()));
        Map map = member.getPermissions();
        if (map != null) {
            member1.setPermissions(new LinkedHashMap<String, char[]>(map));
        }
        member1.setCreatedAt(member.getCreatedAt());
        member1.setUpdatedAt(member.getUpdatedAt());
        return member1;
    }

    @Override
    public MemberEntity toMemberEntity(Member member) {
        if (member == null) {
            return null;
        }
        MemberEntity.MemberEntityBuilder memberEntity = MemberEntity.builder();
        memberEntity.id(member.getId());
        memberEntity.displayName(member.getDisplayName());
        memberEntity.email(member.getEmail());
        memberEntity.type(member.getType());
        memberEntity.referenceType(member.getReferenceType());
        memberEntity.referenceId(member.getReferenceId());
        memberEntity.roles(this.roleListToRoleEntityList(member.getRoles()));
        Map<String, char[]> map = member.getPermissions();
        if (map != null) {
            memberEntity.permissions(new LinkedHashMap<String, char[]>(map));
        }
        memberEntity.createdAt(member.getCreatedAt());
        memberEntity.updatedAt(member.getUpdatedAt());
        return memberEntity.build();
    }

    protected Member.Role roleEntityToRole(RoleEntity roleEntity) {
        if (roleEntity == null) {
            return null;
        }
        Member.Role role = new Member.Role();
        role.setId(roleEntity.getId());
        role.setName(roleEntity.getName());
        role.setDescription(roleEntity.getDescription());
        role.setScope(roleEntity.getScope());
        role.setDefaultRole(roleEntity.isDefaultRole());
        role.setSystem(roleEntity.isSystem());
        Map map = roleEntity.getPermissions();
        if (map != null) {
            role.setPermissions(new LinkedHashMap<String, char[]>(map));
        }
        return role;
    }

    protected List<Member.Role> roleEntityListToRoleList(List<RoleEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Member.Role> list1 = new ArrayList<Member.Role>(list.size());
        for (RoleEntity roleEntity : list) {
            list1.add(this.roleEntityToRole(roleEntity));
        }
        return list1;
    }

    protected RoleEntity roleToRoleEntity(Member.Role role) {
        if (role == null) {
            return null;
        }
        RoleEntity.RoleEntityBuilder roleEntity = RoleEntity.builder();
        roleEntity.id(role.getId());
        roleEntity.name(role.getName());
        roleEntity.description(role.getDescription());
        roleEntity.scope(role.getScope());
        roleEntity.defaultRole(role.isDefaultRole());
        roleEntity.system(role.isSystem());
        Map<String, char[]> map = role.getPermissions();
        if (map != null) {
            roleEntity.permissions(new LinkedHashMap<String, char[]>(map));
        }
        return roleEntity.build();
    }

    protected List<RoleEntity> roleListToRoleEntityList(List<Member.Role> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RoleEntity> list1 = new ArrayList<RoleEntity>(list.size());
        for (Member.Role role : list) {
            list1.add(this.roleToRoleEntity(role));
        }
        return list1;
    }
}

