/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.json.JsonDeserializer;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupDefinition;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.repository.management.model.SharedPolicyGroup;
import io.gravitee.repository.management.model.SharedPolicyGroupLifecycleState;
import io.gravitee.rest.api.model.context.OriginContext;
import java.io.IOException;
import org.mapstruct.AfterMapping;
import org.mapstruct.InjectionStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValueMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(componentModel="spring", uses={JsonDeserializer.class, JsonDeserializer.class}, injectionStrategy=InjectionStrategy.FIELD, nullValueMappingStrategy=NullValueMappingStrategy.RETURN_NULL)
public abstract class SharedPolicyGroupAdapter {
    private final Logger LOGGER = LoggerFactory.getLogger(SharedPolicyGroupAdapter.class);

    @Mapping(target="originContext", expression="java(toOriginContextEnum(sharedPolicyGroup.getOrigin()))")
    public abstract io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup toEntity(SharedPolicyGroup var1);

    @Mappings(value={@Mapping(target="origin", expression="java(toOriginString(sharedPolicyGroupEntity.getOriginContext()))"), @Mapping(target="definition", source=".", qualifiedByName={"serializeDefinition"})})
    public abstract SharedPolicyGroup fromEntity(io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup var1);

    public abstract SharedPolicyGroupLifecycleState fromEntity(SharedPolicyGroup.SharedPolicyGroupLifecycleState var1);

    @AfterMapping
    protected void addPolicyGroupDefinition(@MappingTarget io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup result, SharedPolicyGroup sharedPolicyGroup) {
        String definition = sharedPolicyGroup.getDefinition();
        if (definition == null || definition.isEmpty()) {
            return;
        }
        try {
            SharedPolicyGroupDefinition sharedPolicyGroupDefinition = (SharedPolicyGroupDefinition)GraviteeJacksonMapper.getInstance().readValue(definition, SharedPolicyGroupDefinition.class);
            result.setSteps(sharedPolicyGroupDefinition.getSteps());
        }
        catch (IOException ioe) {
            this.LOGGER.error("Unexpected error while deserializing SharedPolicyGroup definition with id:" + result.getId(), (Throwable)ioe);
        }
    }

    @Named(value="serializeDefinition")
    public String serializeDefinition(io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup sharedPolicyGroupEntity) {
        if (sharedPolicyGroupEntity == null) {
            return null;
        }
        try {
            SharedPolicyGroupDefinition sharedPolicyGroupDefinition = SharedPolicyGroupDefinition.builder().steps(sharedPolicyGroupEntity.getSteps()).build();
            return GraviteeJacksonMapper.getInstance().writeValueAsString((Object)sharedPolicyGroupDefinition);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected error while serializing SharedPolicyGroup definition with id:" + sharedPolicyGroupEntity.getId(), ioe);
        }
    }

    public OriginContext toOriginContextEnum(String origin) {
        if (origin == null) {
            return null;
        }
        if ("MANAGEMENT".equalsIgnoreCase(origin)) {
            return new OriginContext.Management();
        }
        if ("KUBERNETES".equalsIgnoreCase(origin)) {
            return new OriginContext.Kubernetes(OriginContext.Kubernetes.Mode.FULLY_MANAGED);
        }
        return null;
    }

    public String toOriginString(OriginContext originContext) {
        return originContext.name();
    }
}

