/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.log.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.log.crud_service.ConnectionLogsCrudService;
import io.gravitee.apim.core.log.model.BaseConnectionLog;
import io.gravitee.apim.core.log.model.ConnectionLog;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.model.analytics.SearchLogsFilters;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.v4.log.SearchLogsResponse;
import io.gravitee.rest.api.model.v4.log.connection.BaseConnectionLog;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class SearchApplicationConnectionLogsUseCase {
    private static final String UNKNOWN = "Unknown";
    private final ConnectionLogsCrudService connectionLogsCrudService;
    private final ApplicationCrudService applicationCrudService;
    private final PlanCrudService planCrudService;
    private final ApiCrudService apiCrudService;
    private final String UNKNOWN_SERVICE = "1";

    public Output execute(Input input) {
        BaseApplicationEntity application = this.applicationCrudService.findById(input.applicationId(), input.environmentId());
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 20));
        SearchLogsResponse<BaseConnectionLog> response = this.connectionLogsCrudService.searchApplicationConnectionLogs(new ExecutionContext(input.organizationId(), input.environmentId()), input.applicationId(), input.logsFilters(), pageable);
        return this.mapToResponse(application, response);
    }

    private Output mapToResponse(BaseApplicationEntity application, SearchLogsResponse<BaseConnectionLog> logs) {
        long total = logs.total();
        List<ConnectionLog> data = logs.logs().stream().map(log -> this.mapToModel((BaseConnectionLog)log, application)).toList();
        return new Output(total, data);
    }

    private ConnectionLog mapToModel(BaseConnectionLog connectionLog, BaseApplicationEntity application) {
        return ((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((BaseConnectionLog.BaseConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((BaseConnectionLog.BaseConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)((BaseConnectionLog.BaseConnectionLogBuilder)((ConnectionLog.ConnectionLogBuilder)ConnectionLog.builder().applicationId(connectionLog.getApplicationId())).application(application)).apiId(connectionLog.getApiId())).api(this.getApiInfo(connectionLog.getApiId()))).requestId(connectionLog.getRequestId())).timestamp(connectionLog.getTimestamp())).clientIdentifier(connectionLog.getClientIdentifier() != null ? connectionLog.getClientIdentifier() : UNKNOWN)).method(connectionLog.getMethod())).planId(connectionLog.getPlanId())).plan(this.getPlanInfo(connectionLog.getPlanId()))).requestEnded(connectionLog.isRequestEnded())).transactionId(connectionLog.getTransactionId())).status(connectionLog.getStatus())).uri(connectionLog.getUri())).gateway(connectionLog.getGateway())).gatewayResponseTime(connectionLog.getGatewayResponseTime())).build();
    }

    private Api getApiInfo(String apiId) {
        Object unknownApi = ((Api.ApiBuilder)Api.builder().id("1")).build();
        if (apiId == null) {
            return unknownApi;
        }
        try {
            return this.apiCrudService.get(apiId);
        }
        catch (ApiNotFoundException | TechnicalManagementException e) {
            return unknownApi;
        }
    }

    private Plan getPlanInfo(String planId) {
        Object unknownPlan = ((Plan.PlanBuilder)Plan.builder().id("1")).build();
        if (planId == null) {
            return unknownPlan;
        }
        try {
            return this.planCrudService.getById(planId);
        }
        catch (PlanNotFoundException | TechnicalManagementException e) {
            return unknownPlan;
        }
    }

    @Generated
    public SearchApplicationConnectionLogsUseCase(ConnectionLogsCrudService connectionLogsCrudService, ApplicationCrudService applicationCrudService, PlanCrudService planCrudService, ApiCrudService apiCrudService) {
        this.connectionLogsCrudService = connectionLogsCrudService;
        this.applicationCrudService = applicationCrudService;
        this.planCrudService = planCrudService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String applicationId, String organizationId, String environmentId, SearchLogsFilters logsFilters, Optional<Pageable> pageable) {
        public Input(String applicationId, String organizationId, String environmentId, SearchLogsFilters logsFilters) {
            this(applicationId, organizationId, environmentId, logsFilters, Optional.empty());
        }

        public Input(String applicationId, String organizationId, String environmentId, SearchLogsFilters logsFilters, Pageable pageable) {
            this(applicationId, organizationId, environmentId, logsFilters, Optional.of(pageable));
        }
    }

    public record Output(long total, List<ConnectionLog> data) {
    }
}

