/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.BasePlanEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiIdsCalculatorService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.imports.ImportApiJsonNode;
import io.gravitee.rest.api.service.imports.ImportJsonNodeWithIds;
import io.gravitee.rest.api.service.imports.ImportPlanJsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiIdsCalculatorServiceImpl
implements ApiIdsCalculatorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiIdsCalculatorServiceImpl.class);
    private ApiService apiService;
    private PageService pageService;
    private PlanService planService;

    @Override
    public ImportApiJsonNode recalculateApiDefinitionIds(ExecutionContext executionContext, ImportApiJsonNode apiJsonNode) {
        return this.recalculateApiDefinitionIds(executionContext, apiJsonNode, null);
    }

    @Override
    public ImportApiJsonNode recalculateApiDefinitionIds(ExecutionContext executionContext, ImportApiJsonNode apiJsonNode, String urlApiId) {
        if (!apiJsonNode.hasId() || !apiJsonNode.getId().equals(urlApiId)) {
            this.findApiByEnvironmentAndCrossId(executionContext.getEnvironmentId(), apiJsonNode.getCrossId()).ifPresentOrElse(api -> this.recalculateIdsFromCrossId(executionContext, apiJsonNode, (ApiEntity)api), () -> this.recalculateIdsFromDefinitionIds(executionContext.getEnvironmentId(), apiJsonNode, urlApiId));
        }
        return this.generateEmptyIds(apiJsonNode);
    }

    private Optional<ApiEntity> findApiByEnvironmentAndCrossId(String environmentId, String crossId) {
        return crossId == null ? Optional.empty() : this.apiService.findByEnvironmentIdAndCrossId(environmentId, crossId);
    }

    private void recalculateIdsFromCrossId(ExecutionContext executionContext, ImportApiJsonNode apiJsonNode, ApiEntity api) {
        apiJsonNode.setId(api.getId());
        Map<String, String> pagesIdsMap = this.recalculatePageIdsFromCrossIds(executionContext.getEnvironmentId(), api, apiJsonNode);
        this.recalculatePlanIdsFromCrossIds(executionContext, api, apiJsonNode.getPlans(), pagesIdsMap);
    }

    private void recalculatePlanIdsFromCrossIds(ExecutionContext executionContext, ApiEntity api, List<ImportPlanJsonNode> plansNodes, Map<String, String> pagesIdsMap) {
        Map plansByCrossId = this.planService.findByApi(executionContext, api.getId()).stream().filter(plan -> plan.getCrossId() != null).collect(Collectors.toMap(BasePlanEntity::getCrossId, Function.identity()));
        plansNodes.stream().filter(ImportJsonNodeWithIds::hasCrossId).forEach(plan -> {
            PlanEntity matchingPlan = (PlanEntity)plansByCrossId.get(plan.getCrossId());
            plan.setApi(api.getId());
            plan.setId(matchingPlan != null ? matchingPlan.getId() : UuidString.generateRandom());
            ApiIdsCalculatorServiceImpl.recalculateGeneralConditionsPageId(plan, pagesIdsMap);
        });
    }

    private Map<String, String> recalculatePageIdsFromCrossIds(String environmentId, ApiEntity api, ImportApiJsonNode apiJsonNode) {
        List<ImportJsonNodeWithIds> pagesNodes = apiJsonNode.getPages();
        HashMap<String, String> idsMap = new HashMap<String, String>();
        Map pagesByCrossId = this.pageService.findByApi(environmentId, api.getId()).stream().filter(page -> page.getCrossId() != null).collect(Collectors.toMap(PageEntity::getCrossId, Function.identity()));
        pagesNodes.stream().filter(ImportJsonNodeWithIds::hasCrossId).forEach(page -> {
            String pageId = page.hasId() ? page.getId() : null;
            PageEntity matchingPage = (PageEntity)pagesByCrossId.get(page.getCrossId());
            page.setApi(api.getId());
            if (matchingPage != null) {
                idsMap.put(pageId, matchingPage.getId());
                page.setId(matchingPage.getId());
                this.updatePagesHierarchy(pagesNodes, pageId, matchingPage.getId());
            } else {
                String newPageId = this.canRegenerateId(apiJsonNode) ? UuidString.generateRandom() : pageId;
                idsMap.put(pageId, newPageId);
                page.setId(newPageId);
                this.updatePagesHierarchy(pagesNodes, pageId, newPageId);
            }
        });
        return idsMap;
    }

    private void recalculateIdsFromDefinitionIds(String environmentId, ImportApiJsonNode apiJsonNode, String urlApiId) {
        if (this.canRegenerateId(apiJsonNode)) {
            String targetApiId = urlApiId == null ? UuidString.generateForEnvironment(environmentId, apiJsonNode.getId()) : urlApiId;
            apiJsonNode.setId(targetApiId);
            Map<String, String> pagesIdsMap = this.recalculatePageIdsFromDefinitionIds(apiJsonNode.getPages(), environmentId, targetApiId);
            this.recalculatePlanIdsFromDefinitionIds(apiJsonNode.getPlans(), environmentId, targetApiId, pagesIdsMap);
        }
    }

    private void recalculatePlanIdsFromDefinitionIds(List<ImportPlanJsonNode> plansNodes, String environmentId, String apiId, Map<String, String> pagesIdsMap) {
        plansNodes.stream().filter(ImportJsonNodeWithIds::hasId).forEach(plan -> {
            plan.setId(UuidString.generateForEnvironment(environmentId, apiId, plan.getId()));
            plan.setApi(apiId);
            ApiIdsCalculatorServiceImpl.recalculateGeneralConditionsPageId(plan, pagesIdsMap);
        });
    }

    private static void recalculateGeneralConditionsPageId(ImportPlanJsonNode plan, Map<String, String> pagesIdsMap) {
        if (plan.hasGeneralConditions()) {
            plan.setGeneralConditions(pagesIdsMap.get(plan.getGeneralConditions()));
        }
    }

    private Map<String, String> recalculatePageIdsFromDefinitionIds(List<ImportJsonNodeWithIds> pagesNodes, String environmentId, String apiId) {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        pagesNodes.stream().filter(ImportJsonNodeWithIds::hasId).forEach(page -> {
            String oldPageId = page.getId();
            String newPageId = UuidString.generateForEnvironment(environmentId, apiId, oldPageId);
            idsMap.put(oldPageId, newPageId);
            page.setId(newPageId);
            page.setApi(apiId);
            this.updatePagesHierarchy(pagesNodes, oldPageId, newPageId);
        });
        return idsMap;
    }

    private boolean canRegenerateId(ImportApiJsonNode apiJsonNode) {
        return !apiJsonNode.isKubernetesOrigin();
    }

    private void updatePagesHierarchy(List<ImportJsonNodeWithIds> pagesNodes, String parentId, String newParentId) {
        pagesNodes.stream().filter(child -> this.isChildPageOf((ImportJsonNodeWithIds)child, parentId)).forEach(child -> child.setParentId(newParentId));
    }

    private boolean isChildPageOf(ImportJsonNodeWithIds pageNode, String parentPageId) {
        return pageNode.hasParentId() && pageNode.getParentId().equals(parentPageId);
    }

    private ImportApiJsonNode generateEmptyIds(ImportApiJsonNode apiJsonNode) {
        Stream.concat(apiJsonNode.getPlans().stream(), apiJsonNode.getPages().stream()).filter(node -> !node.hasId()).forEach(node -> node.setId(UuidString.generateRandom()));
        return apiJsonNode;
    }

    @Generated
    public ApiIdsCalculatorServiceImpl(ApiService apiService, PageService pageService, PlanService planService) {
        this.apiService = apiService;
        this.pageService = pageService;
        this.planService = planService;
    }
}

