/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.membership.MembershipCommand;
import io.gravitee.cockpit.api.command.v1.membership.MembershipCommandPayload;
import io.gravitee.cockpit.api.command.v1.membership.MembershipReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MembershipCommandHandler
implements CommandHandler<MembershipCommand, MembershipReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MembershipCommandHandler.class);
    private final UserService userService;
    private final RoleService roleService;
    private final MembershipService membershipService;

    public String supportType() {
        return CockpitCommandType.MEMBERSHIP.name();
    }

    public Single<MembershipReply> handle(MembershipCommand command) {
        MembershipCommandPayload membershipPayload = (MembershipCommandPayload)command.getPayload();
        try {
            MembershipReferenceType membershipReferenceType;
            RoleScope roleScope;
            try {
                roleScope = RoleScope.valueOf((String)membershipPayload.referenceType());
                membershipReferenceType = MembershipReferenceType.valueOf((String)membershipPayload.referenceType());
            }
            catch (Exception e) {
                String errorDetails = "Invalid referenceType [%s].".formatted(membershipPayload.referenceType());
                log.error(errorDetails, (Throwable)e);
                return Single.just((Object)new MembershipReply(command.getId(), errorDetails));
            }
            ExecutionContext executionContext = new ExecutionContext(membershipPayload.organizationId(), membershipReferenceType.equals((Object)MembershipReferenceType.ENVIRONMENT) ? membershipPayload.referenceId() : null);
            UserEntity userEntity = this.userService.findBySource(executionContext.getOrganizationId(), "cockpit", membershipPayload.userId(), false);
            RoleEntity roleEntity = this.findRole(executionContext.getOrganizationId(), roleScope, membershipPayload.role());
            MembershipService.MembershipReference membershipReference = new MembershipService.MembershipReference(membershipReferenceType, membershipPayload.referenceId());
            MembershipService.MembershipMember membershipMember = new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER);
            MembershipService.MembershipRole membershipRole = new MembershipService.MembershipRole(roleEntity.getScope(), roleEntity.getName());
            this.membershipService.updateRolesToMemberOnReference(executionContext, membershipReference, membershipMember, Collections.singletonList(membershipRole), "cockpit", false);
            log.info("Role [{}] assigned on {} [{}] for user [{}] and organization [{}].", new Object[]{membershipPayload.role(), membershipPayload.referenceType(), membershipPayload.referenceId(), userEntity.getId(), membershipPayload.organizationId()});
            return Single.just((Object)new MembershipReply(command.getId()));
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when trying to assign role [%s] on %s [%s] for cockpit user [%s] and organization [%s].".formatted(membershipPayload.role(), membershipPayload.referenceType(), membershipPayload.referenceId(), membershipPayload.userId(), membershipPayload.organizationId());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new MembershipReply(command.getId(), errorDetails));
        }
    }

    private RoleEntity findRole(String organizationId, RoleScope roleScope, String roleName) {
        String mappedRoleName = roleName.replace(roleScope.name() + "_", "").replace("PRIMARY_OWNER", "ADMIN").replace("OWNER", "ADMIN");
        Optional<RoleEntity> role = this.roleService.findByScopeAndName(roleScope, mappedRoleName, organizationId);
        if (role.isEmpty()) {
            throw new RoleNotFoundException(roleScope, mappedRoleName);
        }
        return role.get();
    }

    @Generated
    public MembershipCommandHandler(UserService userService, RoleService roleService, MembershipService membershipService) {
        this.userService = userService;
        this.roleService = roleService;
        this.membershipService = membershipService;
    }
}

