/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.apim.core.flow.domain_service.FlowValidationDomainService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.definition.model.v4.service.Service;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.DefinitionVersionException;
import io.gravitee.rest.api.service.exceptions.DynamicPropertiesInvalidException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.LifecycleStateChangeNotAllowedException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.ApiServicePluginService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.gravitee.rest.api.service.v4.exception.ApiTypeException;
import io.gravitee.rest.api.service.v4.validation.AnalyticsValidationService;
import io.gravitee.rest.api.service.v4.validation.ApiValidationService;
import io.gravitee.rest.api.service.v4.validation.EndpointGroupsValidationService;
import io.gravitee.rest.api.service.v4.validation.FlowValidationService;
import io.gravitee.rest.api.service.v4.validation.GroupValidationService;
import io.gravitee.rest.api.service.v4.validation.ListenerValidationService;
import io.gravitee.rest.api.service.v4.validation.PlanValidationService;
import io.gravitee.rest.api.service.v4.validation.ResourcesValidationService;
import io.gravitee.rest.api.service.v4.validation.TagsValidationService;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiValidationServiceImpl
extends TransactionalService
implements ApiValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiValidationServiceImpl.class);
    private final TagsValidationService tagsValidationService;
    private final GroupValidationService groupValidationService;
    private final ListenerValidationService listenerValidationService;
    private final EndpointGroupsValidationService endpointGroupsValidationService;
    private final FlowValidationService flowValidationService;
    private final ResourcesValidationService resourcesValidationService;
    private final AnalyticsValidationService analyticsValidationService;
    private final PlanSearchService planSearchService;
    private final PlanValidationService planValidationService;
    private final ApiServicePluginService apiServicePluginService;
    private final FlowValidationDomainService flowValidationDomainService;

    public ApiValidationServiceImpl(TagsValidationService tagsValidationService, GroupValidationService groupValidationService, ListenerValidationService listenerValidationService, EndpointGroupsValidationService endpointGroupsValidationService, FlowValidationService flowValidationService, ResourcesValidationService resourcesValidationService, AnalyticsValidationService loggingValidationService, PlanSearchService planSearchService, PlanValidationService planValidationService, ApiServicePluginService apiServicePluginService, FlowValidationDomainService flowValidationDomainService) {
        this.tagsValidationService = tagsValidationService;
        this.groupValidationService = groupValidationService;
        this.listenerValidationService = listenerValidationService;
        this.endpointGroupsValidationService = endpointGroupsValidationService;
        this.flowValidationService = flowValidationService;
        this.resourcesValidationService = resourcesValidationService;
        this.analyticsValidationService = loggingValidationService;
        this.planSearchService = planSearchService;
        this.planValidationService = planValidationService;
        this.apiServicePluginService = apiServicePluginService;
        this.flowValidationDomainService = flowValidationDomainService;
    }

    @Override
    public void validateAndSanitizeNewApi(ExecutionContext executionContext, NewApiEntity newApiEntity, PrimaryOwnerEntity primaryOwnerEntity) {
        this.validateDefinitionVersion(null, newApiEntity.getDefinitionVersion());
        this.validateApiType(null, newApiEntity.getType());
        newApiEntity.setTags(this.tagsValidationService.validateAndSanitize(executionContext, null, newApiEntity.getTags()));
        newApiEntity.setGroups(this.groupValidationService.validateAndSanitize(executionContext, null, newApiEntity.getGroups(), null, primaryOwnerEntity, true));
        newApiEntity.setListeners(this.listenerValidationService.validateAndSanitizeHttpV4(executionContext, null, newApiEntity.getListeners(), newApiEntity.getEndpointGroups()));
        newApiEntity.setEndpointGroups(this.endpointGroupsValidationService.validateAndSanitizeHttpV4(newApiEntity.getType(), newApiEntity.getEndpointGroups()));
        newApiEntity.setAnalytics(this.analyticsValidationService.validateAndSanitize(executionContext, newApiEntity.getType(), newApiEntity.getAnalytics()));
        newApiEntity.setFlows(this.flowValidationService.validateAndSanitize(newApiEntity.getType(), newApiEntity.getFlows()));
        this.flowValidationDomainService.validatePathParameters(newApiEntity.getType(), newApiEntity.getFlows() != null ? newApiEntity.getFlows().stream() : Stream.empty(), Stream.empty());
        newApiEntity.setDescription(HtmlSanitizer.sanitize((String)newApiEntity.getDescription()));
    }

    @Override
    public void validateAndSanitizeUpdateApi(ExecutionContext executionContext, UpdateApiEntity updateApiEntity, PrimaryOwnerEntity primaryOwnerEntity, ApiEntity existingApiEntity) {
        this.validateDefinitionVersion(existingApiEntity.getDefinitionVersion(), updateApiEntity.getDefinitionVersion());
        this.validateApiType(existingApiEntity.getType(), updateApiEntity.getType());
        updateApiEntity.setLifecycleState(this.validateAndSanitizeLifecycleState(existingApiEntity, updateApiEntity));
        updateApiEntity.setTags(this.tagsValidationService.validateAndSanitize(executionContext, existingApiEntity.getTags(), updateApiEntity.getTags()));
        updateApiEntity.setGroups(this.groupValidationService.validateAndSanitize(executionContext, updateApiEntity.getId(), updateApiEntity.getGroups(), existingApiEntity.getGroups(), primaryOwnerEntity, false));
        updateApiEntity.setListeners(this.listenerValidationService.validateAndSanitizeHttpV4(executionContext, updateApiEntity.getId(), updateApiEntity.getListeners(), updateApiEntity.getEndpointGroups()));
        updateApiEntity.setEndpointGroups(this.endpointGroupsValidationService.validateAndSanitizeHttpV4(updateApiEntity.getType(), updateApiEntity.getEndpointGroups()));
        updateApiEntity.setAnalytics(this.analyticsValidationService.validateAndSanitize(executionContext, updateApiEntity.getType(), updateApiEntity.getAnalytics()));
        updateApiEntity.setFlows(this.flowValidationService.validateAndSanitize(updateApiEntity.getType(), updateApiEntity.getFlows()));
        updateApiEntity.setPlans(this.planValidationService.validateAndSanitize(updateApiEntity.getType(), updateApiEntity.getPlans()));
        this.flowValidationDomainService.validatePathParameters(updateApiEntity.getType(), updateApiEntity.getFlows() != null ? updateApiEntity.getFlows().stream() : Stream.empty(), this.getPlansFlows(updateApiEntity.getPlans()));
        updateApiEntity.setResources(this.validateAndSanitize(updateApiEntity.getResources()));
        this.validateDynamicProperties(updateApiEntity.getServices() != null ? updateApiEntity.getServices().getDynamicProperty() : null);
    }

    @Override
    public void validateAndSanitizeImportApiForCreation(ExecutionContext executionContext, ApiEntity apiEntity, PrimaryOwnerEntity primaryOwnerEntity) {
        this.validateDefinitionVersion(null, apiEntity.getDefinitionVersion());
        this.validateApiType(null, apiEntity.getType());
        apiEntity.setLifecycleState(null);
        apiEntity.setTags(this.tagsValidationService.validateAndSanitize(executionContext, null, apiEntity.getTags()));
        apiEntity.setGroups(this.groupValidationService.validateAndSanitize(executionContext, null, apiEntity.getGroups(), null, primaryOwnerEntity, true));
        apiEntity.setListeners(this.listenerValidationService.validateAndSanitizeHttpV4(executionContext, null, apiEntity.getListeners(), apiEntity.getEndpointGroups()));
        apiEntity.setEndpointGroups(this.endpointGroupsValidationService.validateAndSanitizeHttpV4(apiEntity.getType(), apiEntity.getEndpointGroups()));
        apiEntity.setAnalytics(this.analyticsValidationService.validateAndSanitize(executionContext, apiEntity.getType(), apiEntity.getAnalytics()));
        apiEntity.setFlows(this.flowValidationService.validateAndSanitize(apiEntity.getType(), apiEntity.getFlows()));
        apiEntity.setPlans(this.planValidationService.validateAndSanitize(apiEntity.getType(), apiEntity.getPlans()));
        this.flowValidationDomainService.validatePathParameters(apiEntity.getType(), apiEntity.getFlows() != null ? apiEntity.getFlows().stream() : Stream.empty(), this.getPlansFlows(apiEntity.getPlans()));
        apiEntity.setResources(this.validateAndSanitize(apiEntity.getResources()));
        apiEntity.setDescription(HtmlSanitizer.sanitize((String)apiEntity.getDescription()));
        this.validateDynamicProperties(apiEntity.getServices() != null ? apiEntity.getServices().getDynamicProperty() : null);
    }

    @Override
    public boolean canDeploy(ExecutionContext executionContext, String apiId) {
        return this.planSearchService.findByApi(executionContext, apiId).stream().anyMatch(planEntity -> PlanStatus.PUBLISHED.equals((Object)planEntity.getPlanStatus()) || PlanStatus.DEPRECATED.equals((Object)planEntity.getPlanStatus()));
    }

    @Override
    public void validateDynamicProperties(Service dynamicProperties) {
        if (dynamicProperties == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)dynamicProperties.getType())) {
            log.debug("Dynamic properties requires a type");
            throw new DynamicPropertiesInvalidException(dynamicProperties.getType());
        }
        dynamicProperties.setConfiguration(this.apiServicePluginService.validateApiServiceConfiguration(dynamicProperties.getType(), dynamicProperties.getConfiguration()));
    }

    @Override
    public List<Resource> validateAndSanitize(List<Resource> resources) {
        return this.resourcesValidationService.validateAndSanitize(resources);
    }

    private Stream<Flow> getPlansFlows(Set<PlanEntity> plans) {
        if (plans == null) {
            return Stream.empty();
        }
        return plans.stream().flatMap(plan -> plan.getFlows() == null ? Stream.empty() : plan.getFlows().stream());
    }

    private void validateDefinitionVersion(DefinitionVersion oldDefinitionVersion, DefinitionVersion newDefinitionVersion) {
        if (newDefinitionVersion != DefinitionVersion.V4) {
            throw new InvalidDataException("Definition version is unsupported, should be V4 or higher");
        }
        if (oldDefinitionVersion != null && oldDefinitionVersion.asInteger() > newDefinitionVersion.asInteger()) {
            throw new DefinitionVersionException();
        }
    }

    private void validateApiType(ApiType oldApiType, ApiType newApiType) {
        if (newApiType == null) {
            throw new InvalidDataException("ApiType cannot be null.");
        }
        if (oldApiType != null && oldApiType != newApiType) {
            throw new ApiTypeException();
        }
    }

    private ApiLifecycleState validateAndSanitizeLifecycleState(ApiEntity existingApiEntity, UpdateApiEntity updateApiEntity) {
        if (updateApiEntity.getLifecycleState() == null) {
            return existingApiEntity.getLifecycleState();
        }
        if (ApiLifecycleState.DEPRECATED == existingApiEntity.getLifecycleState()) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
        if (existingApiEntity.getLifecycleState() == updateApiEntity.getLifecycleState()) {
            return existingApiEntity.getLifecycleState();
        }
        if (ApiLifecycleState.ARCHIVED == existingApiEntity.getLifecycleState() && ApiLifecycleState.ARCHIVED != updateApiEntity.getLifecycleState() || ApiLifecycleState.UNPUBLISHED == existingApiEntity.getLifecycleState() && ApiLifecycleState.CREATED == updateApiEntity.getLifecycleState() || ApiLifecycleState.CREATED == existingApiEntity.getLifecycleState() && WorkflowState.IN_REVIEW == existingApiEntity.getWorkflowState()) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
        return updateApiEntity.getLifecycleState();
    }
}

