/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.model;

import io.gravitee.apim.core.scoring.model.ScoringAssetType;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;

public record ScoringReport(String id, String apiId, String environmentId, ZonedDateTime createdAt, Summary summary, List<Asset> assets) {
    @Generated
    public static ScoringReportBuilder builder() {
        return new ScoringReportBuilder();
    }

    @Generated
    public ScoringReportBuilder toBuilder() {
        return new ScoringReportBuilder().id(this.id).apiId(this.apiId).environmentId(this.environmentId).createdAt(this.createdAt).summary(this.summary).assets(this.assets);
    }

    @Generated
    public ScoringReport withApiId(String apiId) {
        return this.apiId == apiId ? this : new ScoringReport(this.id, apiId, this.environmentId, this.createdAt, this.summary, this.assets);
    }

    public record Summary(Double score, Long errors, Long warnings, Long infos, Long hints) {
    }

    @Generated
    public static class ScoringReportBuilder {
        @Generated
        private String id;
        @Generated
        private String apiId;
        @Generated
        private String environmentId;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private Summary summary;
        @Generated
        private List<Asset> assets;

        @Generated
        ScoringReportBuilder() {
        }

        @Generated
        public ScoringReportBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ScoringReportBuilder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        @Generated
        public ScoringReportBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public ScoringReportBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public ScoringReportBuilder summary(Summary summary) {
            this.summary = summary;
            return this;
        }

        @Generated
        public ScoringReportBuilder assets(List<Asset> assets) {
            this.assets = assets;
            return this;
        }

        @Generated
        public ScoringReport build() {
            return new ScoringReport(this.id, this.apiId, this.environmentId, this.createdAt, this.summary, this.assets);
        }

        @Generated
        public String toString() {
            return "ScoringReport.ScoringReportBuilder(id=" + this.id + ", apiId=" + this.apiId + ", environmentId=" + this.environmentId + ", createdAt=" + this.createdAt + ", summary=" + this.summary + ", assets=" + this.assets + ")";
        }
    }

    public static enum Severity {
        ERROR,
        HINT,
        INFO,
        WARN;

    }

    public record ScoringError(String code, List<String> path) {
    }

    public record Position(int line, int character) {
    }

    public record Range(Position start, Position end) {
    }

    public record Diagnostic(Severity severity, Range range, String rule, String message, String path) {
    }

    public record Asset(String pageId, ScoringAssetType type, List<Diagnostic> diagnostics, List<ScoringError> errors) {
    }
}

