/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.DocumentationValidationDomainService;
import io.gravitee.apim.core.documentation.domain_service.HomepageDomainService;
import io.gravitee.apim.core.documentation.domain_service.PageSourceDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.AccessControl;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.PageSource;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

@UseCase
public class ApiUpdateDocumentationPageUseCase {
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final HomepageDomainService homepageDomainService;
    private final ApiCrudService apiCrudService;
    private final PageCrudService pageCrudService;
    private final PageQueryService pageQueryService;
    private final DocumentationValidationDomainService documentationValidationDomainService;
    private final PageSourceDomainService pageSourceDomainService;

    public Output execute(Input input) {
        Page updatedPage;
        Page pageToUpdate;
        Api api = this.apiCrudService.get(input.apiId);
        Page oldPage = this.pageCrudService.get(input.pageId);
        this.apiDocumentationDomainService.validatePageAssociatedToApi(oldPage, input.apiId);
        Page.PageBuilder newPage = oldPage.toBuilder();
        newPage.updatedAt(new Date());
        newPage.visibility(input.visibility);
        newPage.homepage(input.homepage);
        newPage.order(input.order);
        newPage.configuration(input.configuration);
        newPage.content(input.content);
        newPage.source(input.source);
        String name = this.documentationValidationDomainService.sanitizeDocumentationName(input.name);
        if (!Objects.equals(oldPage.getName(), name)) {
            this.apiDocumentationDomainService.validateNameIsUnique(input.apiId, oldPage.getParentId(), name, oldPage.getType());
            newPage.name(name);
        }
        if (Objects.nonNull(input.excludedAccessControls)) {
            newPage.excludedAccessControls(input.excludedAccessControls);
        }
        if (Objects.nonNull(input.accessControls)) {
            newPage.accessControls(this.documentationValidationDomainService.sanitizeAccessControls(input.accessControls));
        }
        if ((pageToUpdate = newPage.build()).getSource() != null && oldPage.getSource() != null) {
            this.pageSourceDomainService.mergeSensitiveData(oldPage, pageToUpdate);
        }
        if (!Objects.equals(oldPage.getContent(), input.content) || !Objects.equals(oldPage.getSource(), input.source)) {
            pageToUpdate = this.documentationValidationDomainService.validateAndSanitizeForUpdate(pageToUpdate, input.auditInfo().organizationId(), true);
        }
        if (!(updatedPage = this.updateApiDocumentationDomainService.updatePage(pageToUpdate, oldPage, input.auditInfo)).isFolder() && updatedPage.isHomepage() && !oldPage.isHomepage()) {
            this.homepageDomainService.setPreviousHomepageToFalse(input.apiId, updatedPage.getId());
        }
        if (updatedPage.getOrder() != oldPage.getOrder()) {
            this.updatePageOrders(oldPage.getOrder(), updatedPage, input.auditInfo);
        }
        updatedPage = updatedPage.withHidden(this.apiDocumentationDomainService.pageIsHidden(updatedPage)).withGeneralConditions(this.apiDocumentationDomainService.pageIsUsedAsGeneralConditions(updatedPage, api));
        return new Output(updatedPage);
    }

    private void updatePageOrders(int oldOrder, Page updatedPage, AuditInfo auditInfo) {
        int newOrder = updatedPage.getOrder();
        boolean shouldMoveDown = newOrder < oldOrder;
        int orderIncrement = shouldMoveDown ? 1 : -1;
        this.pageQueryService.searchByApiIdAndParentId(updatedPage.getReferenceId(), updatedPage.getParentId()).stream().filter(page -> !Objects.equals(page.getId(), updatedPage.getId())).filter(page -> shouldMoveDown ? this.toBeMovedDown(oldOrder, newOrder, page.getOrder()) : this.toBeMovedUp(oldOrder, newOrder, page.getOrder())).forEach(page -> {
            int updatedOrder = page.getOrder() + orderIncrement;
            this.updateApiDocumentationDomainService.updatePage(page.toBuilder().order(updatedOrder).build(), (Page)page, auditInfo);
        });
    }

    private boolean toBeMovedUp(int oldOrder, int newOrder, int pageOrder) {
        return oldOrder < pageOrder && pageOrder <= newOrder;
    }

    private boolean toBeMovedDown(int oldOrder, int newOrder, int pageOrder) {
        return newOrder <= pageOrder && pageOrder < oldOrder;
    }

    @Generated
    public ApiUpdateDocumentationPageUseCase(UpdateApiDocumentationDomainService updateApiDocumentationDomainService, ApiDocumentationDomainService apiDocumentationDomainService, HomepageDomainService homepageDomainService, ApiCrudService apiCrudService, PageCrudService pageCrudService, PageQueryService pageQueryService, DocumentationValidationDomainService documentationValidationDomainService, PageSourceDomainService pageSourceDomainService) {
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.homepageDomainService = homepageDomainService;
        this.apiCrudService = apiCrudService;
        this.pageCrudService = pageCrudService;
        this.pageQueryService = pageQueryService;
        this.documentationValidationDomainService = documentationValidationDomainService;
        this.pageSourceDomainService = pageSourceDomainService;
    }

    public record Input(String apiId, String pageId, String name, int order, Page.Visibility visibility, String content, boolean homepage, AuditInfo auditInfo, Set<AccessControl> accessControls, Boolean excludedAccessControls, Map<String, String> configuration, PageSource source) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String apiId;
            @Generated
            private String pageId;
            @Generated
            private String name;
            @Generated
            private int order;
            @Generated
            private Page.Visibility visibility;
            @Generated
            private String content;
            @Generated
            private boolean homepage;
            @Generated
            private AuditInfo auditInfo;
            @Generated
            private Set<AccessControl> accessControls;
            @Generated
            private Boolean excludedAccessControls;
            @Generated
            private Map<String, String> configuration;
            @Generated
            private PageSource source;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder apiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            @Generated
            public InputBuilder pageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            @Generated
            public InputBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public InputBuilder order(int order) {
                this.order = order;
                return this;
            }

            @Generated
            public InputBuilder visibility(Page.Visibility visibility) {
                this.visibility = visibility;
                return this;
            }

            @Generated
            public InputBuilder content(String content) {
                this.content = content;
                return this;
            }

            @Generated
            public InputBuilder homepage(boolean homepage) {
                this.homepage = homepage;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public InputBuilder accessControls(Set<AccessControl> accessControls) {
                this.accessControls = accessControls;
                return this;
            }

            @Generated
            public InputBuilder excludedAccessControls(Boolean excludedAccessControls) {
                this.excludedAccessControls = excludedAccessControls;
                return this;
            }

            @Generated
            public InputBuilder configuration(Map<String, String> configuration) {
                this.configuration = configuration;
                return this;
            }

            @Generated
            public InputBuilder source(PageSource source) {
                this.source = source;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.apiId, this.pageId, this.name, this.order, this.visibility, this.content, this.homepage, this.auditInfo, this.accessControls, this.excludedAccessControls, this.configuration, this.source);
            }

            @Generated
            public String toString() {
                return "ApiUpdateDocumentationPageUseCase.Input.InputBuilder(apiId=" + this.apiId + ", pageId=" + this.pageId + ", name=" + this.name + ", order=" + this.order + ", visibility=" + this.visibility + ", content=" + this.content + ", homepage=" + this.homepage + ", auditInfo=" + this.auditInfo + ", accessControls=" + this.accessControls + ", excludedAccessControls=" + this.excludedAccessControls + ", configuration=" + this.configuration + ", source=" + this.source + ")";
            }
        }
    }

    public record Output(Page page) {
    }
}

