/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.swagger;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gravitee.rest.api.service.swagger.SwaggerDescriptor;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.core.util.Yaml31;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.SpecVersion;
import java.util.List;
import lombok.Generated;

public final class OAIDescriptor
implements SwaggerDescriptor<OpenAPI> {
    private final OpenAPI oai;
    private List<String> messages;

    public OAIDescriptor(OpenAPI oai) {
        this.oai = oai;
    }

    @Override
    public OpenAPI getSpecification() {
        return this.oai;
    }

    @Override
    public String toYaml() throws JsonProcessingException {
        if (SpecVersion.V31 == this.oai.getSpecVersion()) {
            return Yaml31.pretty((Object)this.oai);
        }
        return Yaml.pretty((Object)this.oai);
    }

    @Override
    public String toJson() throws JsonProcessingException {
        if (SpecVersion.V31 == this.oai.getSpecVersion()) {
            return Json31.pretty((Object)this.oai);
        }
        return Json.pretty((Object)this.oai);
    }

    @Generated
    public OpenAPI getOai() {
        return this.oai;
    }

    @Generated
    public List<String> getMessages() {
        return this.messages;
    }

    @Generated
    public void setMessages(List<String> messages) {
        this.messages = messages;
    }
}

