/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.specgen;

import io.gravitee.apim.core.specgen.model.ApiSpecGenOperation;
import io.gravitee.apim.core.specgen.model.ApiSpecGenRequestReply;
import io.gravitee.apim.core.specgen.model.ApiSpecGenRequestState;
import io.gravitee.apim.core.specgen.service_provider.SpecGenProvider;
import io.gravitee.cockpit.api.CockpitConnector;
import io.gravitee.cockpit.api.command.v1.specgen.SpecGenCommandPayload;
import io.gravitee.cockpit.api.command.v1.specgen.request.SpecGenRequestCommand;
import io.gravitee.cockpit.api.command.v1.specgen.request.SpecGenRequestReply;
import io.gravitee.exchange.api.command.Command;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.spec.gen.api.EndpointType;
import io.gravitee.spec.gen.api.Operation;
import io.gravitee.spec.gen.api.SpecGenRequest;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SpecGenProviderImpl
implements SpecGenProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpecGenProviderImpl.class);
    private final CockpitConnector cockpitConnector;
    private final InstallationService installationService;
    private final boolean cloudEnabled;
    private final boolean specGenEnabled;

    public SpecGenProviderImpl(@Value(value="${cloud.enabled:false}") boolean cloudEnabled, @Value(value="${spec-gen.enabled:false}") boolean specGenEnabled, @Lazy CockpitConnector cockpitConnector, @Lazy InstallationService installationService) {
        this.cloudEnabled = cloudEnabled;
        this.specGenEnabled = specGenEnabled;
        this.cockpitConnector = cockpitConnector;
        this.installationService = installationService;
    }

    @Override
    public Single<ApiSpecGenRequestReply> performRequest(String apiId, ApiSpecGenOperation operation, String userId) {
        if (!this.cloudEnabled || !this.specGenEnabled) {
            return Single.just((Object)new ApiSpecGenRequestReply(ApiSpecGenRequestState.UNAVAILABLE));
        }
        SpecGenRequestCommand command = new SpecGenRequestCommand(this.buildPayload(apiId, Operation.valueOf((String)operation.name()), userId));
        return this.cockpitConnector.sendCommand((Command)command).cast(SpecGenRequestReply.class).map(reply -> new ApiSpecGenRequestReply(ApiSpecGenRequestState.valueOf(reply.getRequestState().name()))).doOnError(t -> log.error("An error had occurred while sending command [{}] with payload [{}]", new Object[]{command.getId(), command.getPayload(), t})).onErrorResumeWith((SingleSource)Single.just((Object)new ApiSpecGenRequestReply(ApiSpecGenRequestState.UNAVAILABLE)));
    }

    @NotNull
    private SpecGenCommandPayload<SpecGenRequest> buildPayload(String apiId, Operation operation, String userId) {
        ExecutionContext context = GraviteeContext.getExecutionContext();
        return new SpecGenCommandPayload(UuidString.generateRandom(), context.getOrganizationId(), context.getEnvironmentId(), (String)this.installationService.get().getAdditionalInformation().get("COCKPIT_INSTALLATION_ID"), (Object)new SpecGenRequest(apiId, EndpointType.OPEN_API, operation, userId));
    }
}

