/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.validation;

import io.gravitee.apim.core.utils.CollectionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;

public interface Validator<I extends Input> {
    public Result<I> validateAndSanitize(I var1);

    public static class Result<V> {
        private final V value;
        private final List<Error> errors;

        public static <V> Result<V> empty() {
            return new Result<Object>(null, null);
        }

        public static <V> Result<V> ofValue(V value) {
            return new Result<V>(value, List.of());
        }

        public static <V> Result<V> ofErrors(List<Error> errors) {
            return new Result<Object>(null, errors);
        }

        public static <V> Result<V> withError(Error error) {
            return new Result<Object>(null, List.of(error));
        }

        public static <V> Result<V> ofBoth(V value, List<Error> errors) {
            return new Result<V>(value, errors);
        }

        public Result<V> peek(Consumer<V> peekValue, Consumer<List<Error>> peekErrors) {
            this.value().ifPresent(peekValue);
            this.errors().ifPresent(peekErrors);
            return this;
        }

        public <T> Result<T> map(Function<V, T> mapper) {
            return Result.ofBoth(this.value().map(mapper).orElse(null), this.errors);
        }

        public Optional<V> value() {
            return Optional.ofNullable(this.value);
        }

        public Optional<List<Error>> errors() {
            return Optional.ofNullable(this.errors).filter(CollectionUtils::isNotEmpty);
        }

        public Optional<List<Error>> warning() {
            return Optional.of(this.errors().stream().flatMap(Collection::stream).filter(Error::isWarning).toList()).filter(CollectionUtils::isNotEmpty);
        }

        public Optional<List<Error>> severe() {
            return Optional.of(this.errors().stream().flatMap(Collection::stream).filter(Error::isSevere).toList()).filter(CollectionUtils::isNotEmpty);
        }

        @Generated
        private Result(V value, List<Error> errors) {
            this.value = value;
            this.errors = errors;
        }
    }

    public static final class Error {
        private final Severity severity;
        private final String message;

        public static Error severe(String format, Object ... args) {
            return new Error(Severity.SEVERE, String.format(format, args));
        }

        public static Error warning(String format, Object ... args) {
            return new Error(Severity.WARNING, String.format(format, args));
        }

        public boolean isWarning() {
            return this.severity == Severity.WARNING;
        }

        public boolean isSevere() {
            return this.severity == Severity.SEVERE;
        }

        @Generated
        public Error(Severity severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        @Generated
        public Severity getSeverity() {
            return this.severity;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            Severity this$severity = this.getSeverity();
            Severity other$severity = other.getSeverity();
            if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Severity $severity = this.getSeverity();
            result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Validator.Error(severity=" + this.getSeverity() + ", message=" + this.getMessage() + ")";
        }

        static enum Severity {
            WARNING,
            SEVERE;

        }
    }

    public static interface Input {
    }
}

