/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.ApiModel;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiModel;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiModel;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.ApiTemplateService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiTemplateServiceImpl
implements ApiTemplateService {
    private final ApiSearchService apiSearchService;
    private final ApiMetadataService apiMetadataService;
    private final PrimaryOwnerService primaryOwnerService;
    private final NotificationTemplateService notificationTemplateService;

    public ApiTemplateServiceImpl(@Lazy ApiSearchService apiSearchService, ApiMetadataService apiMetadataService, PrimaryOwnerService primaryOwnerService, NotificationTemplateService notificationTemplateService) {
        this.apiSearchService = apiSearchService;
        this.apiMetadataService = apiMetadataService;
        this.primaryOwnerService = primaryOwnerService;
        this.notificationTemplateService = notificationTemplateService;
    }

    @Override
    public GenericApiModel findByIdForTemplates(ExecutionContext executionContext, String apiId, boolean decodeTemplate) {
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, apiId);
        if (genericApiEntity.getDefinitionVersion() == DefinitionVersion.FEDERATED) {
            ApiModel apiModelEntity = new ApiModel();
            apiModelEntity.setId(genericApiEntity.getId());
            apiModelEntity.setDefinitionVersion(genericApiEntity.getDefinitionVersion());
            apiModelEntity.setName(genericApiEntity.getName());
            apiModelEntity.setDescription(genericApiEntity.getDescription());
            apiModelEntity.setCreatedAt(genericApiEntity.getCreatedAt());
            apiModelEntity.setDeployedAt(genericApiEntity.getDeployedAt());
            apiModelEntity.setUpdatedAt(genericApiEntity.getUpdatedAt());
            apiModelEntity.setGroups(genericApiEntity.getGroups());
            apiModelEntity.setVisibility(genericApiEntity.getVisibility());
            apiModelEntity.setCategories(genericApiEntity.getCategories());
            apiModelEntity.setApiVersion(genericApiEntity.getApiVersion());
            apiModelEntity.setState(genericApiEntity.getState());
            apiModelEntity.setTags(genericApiEntity.getTags());
            apiModelEntity.setPicture(genericApiEntity.getPicture());
            apiModelEntity.setPrimaryOwner(genericApiEntity.getPrimaryOwner());
            apiModelEntity.setLifecycleState(genericApiEntity.getLifecycleState());
            apiModelEntity.setDisableMembershipNotifications(genericApiEntity.isDisableMembershipNotifications());
            apiModelEntity.setMetadata(this.getApiMetadata(executionContext, apiId, decodeTemplate, (GenericApiModel)apiModelEntity));
            return apiModelEntity;
        }
        if (genericApiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            ApiEntity apiEntity = (ApiEntity)genericApiEntity;
            io.gravitee.rest.api.model.ApiModel apiModelEntity = new io.gravitee.rest.api.model.ApiModel();
            apiModelEntity.setId(apiEntity.getId());
            apiModelEntity.setDefinitionVersion(apiEntity.getDefinitionVersion());
            apiModelEntity.setName(apiEntity.getName());
            apiModelEntity.setDescription(apiEntity.getDescription());
            apiModelEntity.setCreatedAt(apiEntity.getCreatedAt());
            apiModelEntity.setDeployedAt(apiEntity.getDeployedAt());
            apiModelEntity.setUpdatedAt(apiEntity.getUpdatedAt());
            apiModelEntity.setGroups(apiEntity.getGroups());
            apiModelEntity.setVisibility(apiEntity.getVisibility());
            apiModelEntity.setCategories(apiEntity.getCategories());
            apiModelEntity.setVersion(apiEntity.getVersion());
            apiModelEntity.setState(apiEntity.getState());
            apiModelEntity.setTags(apiEntity.getTags());
            apiModelEntity.setPicture(apiEntity.getPicture());
            apiModelEntity.setPrimaryOwner(apiEntity.getPrimaryOwner());
            apiModelEntity.setProperties(apiEntity.getProperties());
            apiModelEntity.setLifecycleState(apiEntity.getLifecycleState());
            apiModelEntity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
            apiModelEntity.setServices(apiEntity.getServices());
            apiModelEntity.setExecutionMode(apiEntity.getExecutionMode());
            apiModelEntity.setPaths(apiEntity.getPaths());
            apiModelEntity.setProxy(apiEntity.getProxy());
            apiModelEntity.setMetadata(this.getApiMetadata(executionContext, apiId, decodeTemplate, (GenericApiModel)apiModelEntity));
            return apiModelEntity;
        }
        if (genericApiEntity.getDefinitionVersion() == DefinitionVersion.V4 && genericApiEntity instanceof NativeApiEntity) {
            NativeApiEntity apiEntity = (NativeApiEntity)genericApiEntity;
            NativeApiModel apiModelEntity = new NativeApiModel();
            apiModelEntity.setId(apiEntity.getId());
            apiModelEntity.setDefinitionVersion(apiEntity.getDefinitionVersion());
            apiModelEntity.setName(apiEntity.getName());
            apiModelEntity.setDescription(apiEntity.getDescription());
            apiModelEntity.setCreatedAt(apiEntity.getCreatedAt());
            apiModelEntity.setDeployedAt(apiEntity.getDeployedAt());
            apiModelEntity.setUpdatedAt(apiEntity.getUpdatedAt());
            apiModelEntity.setGroups(apiEntity.getGroups());
            apiModelEntity.setVisibility(apiEntity.getVisibility());
            apiModelEntity.setCategories(apiEntity.getCategories());
            apiModelEntity.setApiVersion(apiEntity.getApiVersion());
            apiModelEntity.setState(apiEntity.getState());
            apiModelEntity.setTags(apiEntity.getTags());
            apiModelEntity.setPicture(apiEntity.getPicture());
            apiModelEntity.setPrimaryOwner(apiEntity.getPrimaryOwner());
            apiModelEntity.setProperties(apiEntity.getProperties());
            apiModelEntity.setLifecycleState(apiEntity.getLifecycleState());
            apiModelEntity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
            apiModelEntity.setServices(apiEntity.getServices());
            apiModelEntity.setListeners(apiEntity.getListeners());
            apiModelEntity.setEndpointGroups(apiEntity.getEndpointGroups());
            apiModelEntity.setMetadata(this.getApiMetadata(executionContext, apiId, decodeTemplate, (GenericApiModel)apiModelEntity));
            return apiModelEntity;
        }
        io.gravitee.rest.api.model.v4.api.ApiEntity apiEntity = (io.gravitee.rest.api.model.v4.api.ApiEntity)genericApiEntity;
        ApiModel apiModelEntity = new ApiModel();
        apiModelEntity.setId(apiEntity.getId());
        apiModelEntity.setDefinitionVersion(apiEntity.getDefinitionVersion());
        apiModelEntity.setName(apiEntity.getName());
        apiModelEntity.setDescription(apiEntity.getDescription());
        apiModelEntity.setCreatedAt(apiEntity.getCreatedAt());
        apiModelEntity.setDeployedAt(apiEntity.getDeployedAt());
        apiModelEntity.setUpdatedAt(apiEntity.getUpdatedAt());
        apiModelEntity.setGroups(apiEntity.getGroups());
        apiModelEntity.setVisibility(apiEntity.getVisibility());
        apiModelEntity.setCategories(apiEntity.getCategories());
        apiModelEntity.setApiVersion(apiEntity.getApiVersion());
        apiModelEntity.setState(apiEntity.getState());
        apiModelEntity.setTags(apiEntity.getTags());
        apiModelEntity.setPicture(apiEntity.getPicture());
        apiModelEntity.setPrimaryOwner(apiEntity.getPrimaryOwner());
        apiModelEntity.setProperties(apiEntity.getProperties());
        apiModelEntity.setLifecycleState(apiEntity.getLifecycleState());
        apiModelEntity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        apiModelEntity.setServices(apiEntity.getServices());
        apiModelEntity.setListeners(apiEntity.getListeners());
        apiModelEntity.setEndpointGroups(apiEntity.getEndpointGroups());
        apiModelEntity.setMetadata(this.getApiMetadata(executionContext, apiId, decodeTemplate, (GenericApiModel)apiModelEntity));
        return apiModelEntity;
    }

    private Map<String, String> getApiMetadata(ExecutionContext executionContext, String apiId, boolean decodeTemplate, GenericApiModel genericApiModel) {
        List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(executionContext, apiId);
        if (metadataList == null) {
            return Map.of();
        }
        HashMap<String, String> mapMetadata = new HashMap<String, String>(metadataList.size());
        metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue() == null ? metadata.getDefaultValue() : metadata.getValue()));
        try {
            return decodeTemplate ? this.decodeMetadata(executionContext, genericApiModel, mapMetadata) : mapMetadata;
        }
        catch (Exception ex) {
            throw new TechnicalManagementException("An error occurs while evaluating API metadata", ex);
        }
    }

    private Map<String, String> decodeMetadata(ExecutionContext executionContext, GenericApiModel genericApiModel, Map<String, String> metadata) {
        try {
            String decodedValue = this.notificationTemplateService.resolveInlineTemplateWithParam(executionContext.getOrganizationId(), genericApiModel.getId(), new StringReader(metadata.toString()), Collections.singletonMap("api", genericApiModel));
            Map<String, String> decodedMetadata = Arrays.stream(decodedValue.substring(1, decodedValue.length() - 1).split(", ")).map(entry -> entry.split("=", 2)).collect(Collectors.toMap(entry -> entry[0], entry -> ((String[])entry).length > 1 ? entry[1] : ""));
            String supportEmail = decodedMetadata.getOrDefault("email-support", "");
            if (supportEmail.isBlank()) {
                decodedMetadata.put("email-support", this.primaryOwnerService.getPrimaryOwnerEmail(executionContext.getOrganizationId(), genericApiModel.getId()));
            }
            return decodedMetadata;
        }
        catch (Exception ex) {
            throw new TechnicalManagementException("An error occurs while evaluating API metadata", ex);
        }
    }
}

