/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentFederationAgentRoleUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentFederationAgentRoleUpgrader.class);
    private final RoleService roleService;
    private final OrganizationRepository organizationRepository;

    @Autowired
    public EnvironmentFederationAgentRoleUpgrader(RoleService roleService, @Lazy OrganizationRepository organizationRepository) {
        this.roleService = roleService;
        this.organizationRepository = organizationRepository;
    }

    public boolean upgrade() {
        try {
            this.organizationRepository.findAll().stream().filter(organization -> this.shouldCreateEnvironmentFederationAgentRole(organization.getId())).forEach(organization -> this.roleService.create(new ExecutionContext(organization.getId()), DefaultRoleEntityDefinition.ROLE_ENVIRONMENT_FEDERATION_AGENT));
        }
        catch (Exception e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean shouldCreateEnvironmentFederationAgentRole(String organizationId) {
        return this.roleService.findByScopeAndName(RoleScope.ENVIRONMENT, DefaultRoleEntityDefinition.ROLE_ENVIRONMENT_FEDERATION_AGENT.getName(), organizationId).isEmpty();
    }

    public int getOrder() {
        return 121;
    }
}

