/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.initializer;

import io.gravitee.exchange.api.configuration.IdentifyConfiguration;
import io.gravitee.exchange.api.controller.ExchangeController;
import io.gravitee.node.api.initializer.Initializer;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class IntegrationControllerInitializer
implements Initializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationControllerInitializer.class);
    private final ExchangeController integrationExchangeController;
    private final IdentifyConfiguration identifyConfiguration;

    public IntegrationControllerInitializer(@Qualifier(value="integrationExchangeController") Optional<ExchangeController> integrationExchangeController, @Qualifier(value="integrationIdentifyConfiguration") Optional<IdentifyConfiguration> identifyConfiguration) {
        this.integrationExchangeController = integrationExchangeController.orElse(null);
        this.identifyConfiguration = identifyConfiguration.orElse(null);
    }

    public boolean initialize() {
        if (this.shouldStart()) {
            try {
                this.integrationExchangeController.start();
                log.info("Integrations started.");
            }
            catch (Exception e) {
                log.error("Fail to start Integration Controller", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private boolean shouldStart() {
        return this.identifyConfiguration != null && (Boolean)this.identifyConfiguration.getProperty("enabled", Boolean.class, (Object)false) != false;
    }

    public int getOrder() {
        return 100;
    }
}

