/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.model.command.CommandEntity;
import io.gravitee.rest.api.model.command.CommandTags;
import io.gravitee.rest.api.model.notification.NotificationTemplateCommandEntity;
import io.gravitee.rest.api.service.NotificationTemplateCommandListener;
import io.gravitee.rest.api.service.event.CommandEvent;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.v4.mapper.NotificationTemplateMapper;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NotificationTemplateCommandListenerImpl
implements NotificationTemplateCommandListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationTemplateCommandListenerImpl.class);
    private final ObjectMapper objectMapper;
    private final NotificationTemplateService notificationTemplateService;
    private final NotificationTemplateMapper notificationTemplateMapper;

    public NotificationTemplateCommandListenerImpl(EventManager eventManager, ObjectMapper objectMapper, NotificationTemplateService notificationTemplateService, NotificationTemplateMapper notificationTemplateMapper) {
        this.objectMapper = objectMapper;
        this.notificationTemplateService = notificationTemplateService;
        this.notificationTemplateMapper = notificationTemplateMapper;
        eventManager.subscribeForEvents((EventListener)this, CommandEvent.class);
    }

    public void onEvent(Event<CommandEvent, CommandEntity> event) {
        if (event != null && CommandEvent.TO_PROCESS.equals(event.type()) && event.content() != null && ((CommandEntity)event.content()).getTags().contains(CommandTags.EMAIL_TEMPLATE_UPDATE)) {
            log.debug("Command event: {}", (Object)((CommandEntity)event.content()).getContent());
            NotificationTemplateCommandEntity notificationTemplate = this.getNotificationTemplate(((CommandEntity)event.content()).getContent());
            String organizationId = ((CommandEntity)event.content()).getOrganizationId();
            if (notificationTemplate != null && organizationId != null) {
                this.notificationTemplateService.updateFreemarkerCache(this.notificationTemplateMapper.toNotificationTemplateEntity(notificationTemplate), organizationId);
            }
        }
    }

    private NotificationTemplateCommandEntity getNotificationTemplate(String content) {
        try {
            return (NotificationTemplateCommandEntity)this.objectMapper.readValue(content, NotificationTemplateCommandEntity.class);
        }
        catch (JsonProcessingException e) {
            log.error("Error processing NotificationTemplateCommand", (Throwable)e);
            return null;
        }
    }
}

