/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.util.Maps;
import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.MetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewReferenceMetadataEntity;
import io.gravitee.rest.api.model.ReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateReferenceMetadataEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.MetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiMetadataNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationMetadataNotFoundException;
import io.gravitee.rest.api.service.exceptions.DuplicateMetadataNameException;
import io.gravitee.rest.api.service.exceptions.MetadataNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.sanitizer.CustomFieldSanitizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class AbstractReferenceMetadataService
extends AbstractService {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractReferenceMetadataService.class);
    @Lazy
    @Autowired
    protected MetadataRepository metadataRepository;
    @Autowired
    protected MetadataService metadataService;
    @Autowired
    private AuditService auditService;

    protected List<ReferenceMetadataEntity> findAllByReference(MetadataReferenceType referenceType, String referenceId) {
        return this.findAllByReference(referenceType, referenceId, Optional.empty());
    }

    protected List<ReferenceMetadataEntity> findAllByReference(MetadataReferenceType referenceType, String referenceId, Optional<String> environmentId) {
        try {
            this.LOGGER.debug("Find all metadata by reference {} / {}", (Object)referenceType, (Object)referenceId);
            List referenceMetadataList = this.metadataRepository.findByReferenceTypeAndReferenceId(referenceType, referenceId);
            Map referenceMetadataMap = referenceMetadataList.stream().map(this::convert).peek(m -> m.setValue(m.getValue() == null ? "" : m.getValue())).collect(Collectors.toMap(ReferenceMetadataEntity::getKey, Function.identity()));
            ArrayList<ReferenceMetadataEntity> allMetadata = new ArrayList<ReferenceMetadataEntity>();
            if (!MetadataReferenceType.ENVIRONMENT.equals((Object)referenceType) && environmentId.isPresent()) {
                List<MetadataEntity> defaultMetadataList = this.metadataService.findByReferenceTypeAndReferenceId(MetadataReferenceType.ENVIRONMENT, environmentId.get());
                defaultMetadataList.forEach(defaultMetadata -> {
                    ReferenceMetadataEntity referenceMetadataEntity = (ReferenceMetadataEntity)referenceMetadataMap.get(defaultMetadata.getKey());
                    if (referenceMetadataEntity != null) {
                        referenceMetadataEntity.setDefaultValue(defaultMetadata.getValue());
                    } else {
                        Optional<Metadata> optReferenceMetadata = referenceMetadataList.stream().filter(referenceMetadata -> defaultMetadata.getKey().equals(referenceMetadata.getKey())).findAny();
                        allMetadata.add(this.convert(optReferenceMetadata, (MetadataEntity)defaultMetadata));
                    }
                });
            }
            allMetadata.addAll(referenceMetadataMap.values());
            return allMetadata;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to find all metadata by REFERENCE", (Throwable)ex);
            throw new TechnicalManagementException("An error occurred while trying to find all metadata by REFERENCE", ex);
        }
    }

    protected ReferenceMetadataEntity findByIdAndReference(String metadataId, MetadataReferenceType referenceType, String referenceId, Optional<String> environmentId) {
        this.LOGGER.debug("Find metadata by id {} and reference {} / {}", new Object[]{metadataId, referenceType, referenceId});
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(referenceType, referenceId, environmentId);
        Optional<ReferenceMetadataEntity> optMetadata = allMetadata.stream().filter(m -> metadataId.equals(m.getKey())).findAny();
        if (optMetadata.isPresent()) {
            ReferenceMetadataEntity metadata = optMetadata.get();
            if (metadata.getValue() == null) {
                metadata.setValue(metadata.getDefaultValue());
            }
            return metadata;
        }
        if (referenceType.equals((Object)MetadataReferenceType.APPLICATION)) {
            throw new ApplicationMetadataNotFoundException(referenceId, metadataId);
        }
        throw new ApiMetadataNotFoundException(referenceId, metadataId);
    }

    protected void delete(ExecutionContext executionContext, String metadataId, MetadataReferenceType referenceType, String referenceId) {
        this.LOGGER.debug("Delete metadata by id {} and reference {} / {}", new Object[]{metadataId, referenceType, referenceId});
        try {
            Optional optMetadata = this.metadataRepository.findById(metadataId, referenceId, referenceType);
            if (!optMetadata.isPresent()) {
                if (referenceType.equals((Object)MetadataReferenceType.APPLICATION)) {
                    throw new ApplicationMetadataNotFoundException(referenceId, metadataId);
                }
                if (referenceType.equals((Object)MetadataReferenceType.API)) {
                    throw new ApiMetadataNotFoundException(referenceId, metadataId);
                }
                throw new MetadataNotFoundException(metadataId);
            }
            this.metadataRepository.delete(metadataId, referenceId, referenceType);
            this.createReferenceAuditLog(executionContext, referenceType, referenceId, (Metadata)optMetadata.get(), null, Metadata.AuditEvent.METADATA_DELETED);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to delete metadata " + metadataId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    protected ReferenceMetadataEntity create(ExecutionContext executionContext, NewReferenceMetadataEntity metadataEntity, MetadataReferenceType referenceType, String referenceId, boolean withDefaultValue) {
        if (metadataEntity.getFormat() == null) {
            metadataEntity.setFormat(MetadataFormat.STRING);
        }
        this.checkReferenceMetadataFormat(executionContext, metadataEntity.getFormat(), metadataEntity.getValue(), referenceType, referenceId);
        Optional<ReferenceMetadataEntity> optionalMetadata = this.findAllByReference(referenceType, referenceId).stream().filter(metadata -> metadataEntity.getName().equalsIgnoreCase(metadata.getName())).findAny();
        if (optionalMetadata.isPresent()) {
            throw new DuplicateMetadataNameException(optionalMetadata.get().getName());
        }
        try {
            Metadata metadata2 = this.convertForReference(metadataEntity, referenceType, referenceId);
            Date now = new Date();
            metadata2.setCreatedAt(now);
            metadata2.setUpdatedAt(now);
            this.metadataRepository.create(metadata2);
            this.createReferenceAuditLog(executionContext, referenceType, referenceId, null, metadata2, Metadata.AuditEvent.METADATA_CREATED);
            ReferenceMetadataEntity referenceMetadataEntity = this.convert(metadata2);
            if (withDefaultValue) {
                return this.fillDefaultValue(executionContext, referenceMetadataEntity);
            }
            return referenceMetadataEntity;
        }
        catch (TechnicalException ex) {
            String message = "An error occurred while trying to create metadata " + metadataEntity.getName() + " on reference " + referenceId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    protected abstract void checkReferenceMetadataFormat(ExecutionContext var1, MetadataFormat var2, String var3, MetadataReferenceType var4, String var5);

    private void createReferenceAuditLog(ExecutionContext executionContext, MetadataReferenceType referenceType, String referenceId, Metadata oldMetadata, Metadata metadata, Metadata.AuditEvent auditEvent) {
        String key = metadata == null ? oldMetadata.getKey() : metadata.getKey();
        Date updatedAt = metadata == null ? oldMetadata.getUpdatedAt() : metadata.getUpdatedAt();
        switch (referenceType) {
            case API: {
                this.auditService.createApiAuditLog(executionContext, referenceId, Collections.singletonMap(Audit.AuditProperties.METADATA, key), (Audit.AuditEvent)auditEvent, updatedAt, oldMetadata, metadata);
                break;
            }
            case APPLICATION: {
                this.auditService.createApplicationAuditLog(executionContext, referenceId, Collections.singletonMap(Audit.AuditProperties.METADATA, key), (Audit.AuditEvent)auditEvent, updatedAt, oldMetadata, metadata);
                break;
            }
            case USER: {
                this.auditService.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), Maps.builder().put((Object)Audit.AuditProperties.USER, (Object)referenceId).put((Object)Audit.AuditProperties.METADATA, (Object)key).build(), (Audit.AuditEvent)auditEvent, updatedAt, oldMetadata, metadata);
            }
        }
    }

    protected ReferenceMetadataEntity update(ExecutionContext executionContext, UpdateReferenceMetadataEntity metadataEntity, MetadataReferenceType referenceType, String referenceId, boolean withDefaultValue) {
        this.checkReferenceMetadataFormat(executionContext, metadataEntity.getFormat(), metadataEntity.getValue(), referenceType, referenceId);
        try {
            Metadata savedMetadata;
            Metadata metadata = this.convertForReference(metadataEntity, referenceType, referenceId);
            Optional referenceMetadata = this.metadataRepository.findById(metadata.getKey(), referenceId, referenceType);
            Date now = new Date();
            if (referenceMetadata.isPresent()) {
                metadata.setUpdatedAt(now);
                savedMetadata = this.metadataRepository.update(metadata);
                this.createReferenceAuditLog(executionContext, referenceType, referenceId, (Metadata)referenceMetadata.get(), metadata, Metadata.AuditEvent.METADATA_UPDATED);
            } else {
                metadata.setCreatedAt(now);
                metadata.setUpdatedAt(now);
                savedMetadata = this.metadataRepository.create(metadata);
                this.createReferenceAuditLog(executionContext, referenceType, referenceId, null, metadata, Metadata.AuditEvent.METADATA_CREATED);
            }
            ReferenceMetadataEntity referenceMetadataEntity = this.convert(savedMetadata);
            if (withDefaultValue) {
                return this.fillDefaultValue(executionContext, referenceMetadataEntity);
            }
            return referenceMetadataEntity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurred while trying to update metadata {} on REFERENCE {}", new Object[]{metadataEntity.getName(), referenceId, ex});
            throw new TechnicalManagementException("An error occurred while trying to update metadata " + metadataEntity.getName() + " on REFERENCE " + referenceId, ex);
        }
    }

    private ReferenceMetadataEntity fillDefaultValue(ExecutionContext executionContext, ReferenceMetadataEntity referenceMetadataEntity) {
        MetadataEntity defaultValue = this.metadataService.findByKeyAndReferenceTypeAndReferenceId(referenceMetadataEntity.getKey(), MetadataReferenceType.ENVIRONMENT, executionContext.getEnvironmentId());
        if (defaultValue != null) {
            referenceMetadataEntity.setDefaultValue(defaultValue.getValue());
        }
        return referenceMetadataEntity;
    }

    private ReferenceMetadataEntity convert(Optional<Metadata> optMetadata, MetadataEntity defaultMetadata) {
        Metadata metadata;
        if (optMetadata.isPresent()) {
            metadata = optMetadata.get();
        } else {
            metadata = this.convert(defaultMetadata);
            metadata.setValue(null);
        }
        ReferenceMetadataEntity referenceMetadataEntity = this.convert(metadata);
        referenceMetadataEntity.setDefaultValue(defaultMetadata.getValue());
        return referenceMetadataEntity;
    }

    private ReferenceMetadataEntity convert(Metadata metadata) {
        ReferenceMetadataEntity referenceMetadataEntity = new ReferenceMetadataEntity();
        referenceMetadataEntity.setValue(metadata.getValue());
        referenceMetadataEntity.setKey(metadata.getKey());
        referenceMetadataEntity.setName(metadata.getName());
        referenceMetadataEntity.setFormat(MetadataFormat.valueOf((String)metadata.getFormat().name()));
        return referenceMetadataEntity;
    }

    private Metadata convert(MetadataEntity metadataEntity) {
        Metadata metadata = new Metadata();
        metadata.setKey(metadataEntity.getKey());
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(io.gravitee.repository.management.model.MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        return metadata;
    }

    private Metadata convertForReference(NewReferenceMetadataEntity metadataEntity, MetadataReferenceType referenceType, String referenceId) {
        Metadata metadata = new Metadata();
        metadata.setKey(referenceType.equals((Object)MetadataReferenceType.USER) ? CustomFieldSanitizer.formatKeyValue(metadataEntity.getName()) : IdGenerator.generate((String)metadataEntity.getName()));
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(io.gravitee.repository.management.model.MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        metadata.setReferenceId(referenceId);
        metadata.setReferenceType(referenceType);
        return metadata;
    }

    private Metadata convertForReference(UpdateReferenceMetadataEntity metadataEntity, MetadataReferenceType referenceType, String referenceId) {
        Metadata metadata = new Metadata();
        if (metadataEntity.getKey() == null) {
            metadata.setKey(referenceType.equals((Object)MetadataReferenceType.USER) ? CustomFieldSanitizer.formatKeyValue(metadataEntity.getName()) : IdGenerator.generate((String)metadataEntity.getName()));
        } else {
            metadata.setKey(metadataEntity.getKey());
        }
        metadata.setName(metadataEntity.getName());
        metadata.setFormat(io.gravitee.repository.management.model.MetadataFormat.valueOf((String)metadataEntity.getFormat().name()));
        if (metadataEntity.getValue() != null) {
            if (MetadataFormat.DATE.equals((Object)metadataEntity.getFormat())) {
                metadata.setValue(metadataEntity.getValue().substring(0, 10));
            } else {
                metadata.setValue(metadataEntity.getValue());
            }
        }
        metadata.setReferenceId(referenceId);
        metadata.setReferenceType(referenceType);
        return metadata;
    }
}

