/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.bridge.operation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommandPayload;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReply;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReplyPayload;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperation;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperationHandler;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ListEnvironmentOperationHandler
implements BridgeOperationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ListEnvironmentOperationHandler.class);
    private final EnvironmentService environmentService;
    private final InstallationService installationService;
    private final ObjectMapper objectMapper;

    @Override
    public boolean canHandle(String bridgeOperation) {
        return Objects.equals(BridgeOperation.LIST_ENVIRONMENT.name(), bridgeOperation);
    }

    @Override
    public Single<BridgeReply> handle(BridgeCommand bridgeCommand) {
        String organizationId = ((BridgeCommandPayload)bridgeCommand.getPayload()).organizationId();
        try {
            List<BridgeReplyPayload.BridgeReplyContent> replyContents = this.environmentService.findByOrganization(organizationId).stream().map(environmentEntity -> {
                BridgeReplyPayload.BridgeReplyContent.BridgeReplyContentBuilder builder = BridgeReplyPayload.BridgeReplyContent.builder().environmentId(environmentEntity.getId()).organizationId(environmentEntity.getOrganizationId()).installationId(this.installationService.get().getId());
                try {
                    return builder.content(this.objectMapper.writeValueAsString(environmentEntity)).build();
                }
                catch (JsonProcessingException e) {
                    log.warn("Problem while serializing environment {}", (Object)environmentEntity.getId());
                    return builder.error(true).build();
                }
            }).filter(Objects::nonNull).toList();
            return Single.just((Object)new BridgeReply(bridgeCommand.getId(), new BridgeReplyPayload(false, replyContents)));
        }
        catch (TechnicalManagementException ex) {
            return Single.just((Object)new BridgeReply(bridgeCommand.getId(), "No environment available for organization: " + organizationId));
        }
    }

    @Generated
    public ListEnvironmentOperationHandler(EnvironmentService environmentService, InstallationService installationService, ObjectMapper objectMapper) {
        this.environmentService = environmentService;
        this.installationService = installationService;
        this.objectMapper = objectMapper;
    }
}

