/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.api_health;

import io.gravitee.apim.core.api_health.model.AvailabilityHealthCheck;
import io.gravitee.apim.core.api_health.model.AverageHealthCheckResponseTime;
import io.gravitee.apim.core.api_health.model.AverageHealthCheckResponseTimeOvertime;
import io.gravitee.apim.core.api_health.model.HealthCheckLog;
import io.gravitee.apim.core.api_health.query_service.ApiHealthQueryService;
import io.gravitee.apim.infra.adapter.ApiHealthAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.common.query.QueryContext;
import io.gravitee.repository.healthcheck.v4.api.HealthCheckRepository;
import io.reactivex.rxjava3.core.Maybe;
import java.util.ArrayList;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApiHealthQueryServiceImpl
implements ApiHealthQueryService {
    private final HealthCheckRepository healthCheckRepository;

    public ApiHealthQueryServiceImpl(@Lazy HealthCheckRepository healthCheckRepository) {
        this.healthCheckRepository = healthCheckRepository;
    }

    @Override
    public Maybe<AverageHealthCheckResponseTime> averageResponseTime(ApiHealthQueryService.ApiFieldPeriodQuery query) {
        return this.healthCheckRepository.averageResponseTime(new QueryContext(query.organizationId(), query.environmentId()), ApiHealthAdapter.INSTANCE.map(query)).map(ApiHealthAdapter.INSTANCE::map);
    }

    @Override
    public Maybe<AverageHealthCheckResponseTimeOvertime> averageResponseTimeOvertime(ApiHealthQueryService.AverageHealthCheckResponseTimeOvertimeQuery query) {
        return this.healthCheckRepository.averageResponseTimeOvertime(new QueryContext(query.organizationId(), query.environmentId()), ApiHealthAdapter.INSTANCE.map(query)).map(result -> new AverageHealthCheckResponseTimeOvertime(new AverageHealthCheckResponseTimeOvertime.TimeRange(query.from(), query.to(), query.interval()), new ArrayList<Long>(result.buckets().values())));
    }

    @Override
    public Maybe<AvailabilityHealthCheck> availability(ApiHealthQueryService.ApiFieldPeriodQuery query) {
        return this.healthCheckRepository.availability(new QueryContext(query.organizationId(), query.environmentId()), ApiHealthAdapter.INSTANCE.map(query)).map(response -> new AvailabilityHealthCheck(response.global(), response.ratesByFields()));
    }

    @Override
    public Maybe<Page<HealthCheckLog>> searchLogs(ApiHealthQueryService.SearchLogsQuery query) {
        return this.healthCheckRepository.searchLogs(new QueryContext(query.organizationId(), query.environmentId()), ApiHealthAdapter.INSTANCE.map(query)).map(page -> page.map(ApiHealthAdapter.INSTANCE::map));
    }
}

