/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.json.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.gravitee.apim.core.json.JsonSerializer;
import io.gravitee.apim.infra.json.jackson.GraviteeDefinitionJacksonJsonSerializer;
import io.gravitee.apim.infra.json.jackson.JacksonJsonDeserializer;
import io.gravitee.apim.infra.json.jackson.JacksonJsonDiffProcessor;
import io.gravitee.apim.infra.json.jackson.JacksonJsonSerializer;
import io.gravitee.apim.infra.json.jackson.JsonMapperFactory;
import javax.inject.Singleton;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JacksonSpringConfiguration {
    @Bean
    @Qualifier(value="defaultMapper")
    @Singleton
    public JsonMapper defaultJsonMapper() {
        return JsonMapperFactory.build();
    }

    @Bean
    public JsonSerializer jsonSerializer(@Qualifier(value="defaultMapper") JsonMapper mapper) {
        return new JacksonJsonSerializer(mapper);
    }

    @Bean
    public JacksonJsonDeserializer jsonDeserializer(@Qualifier(value="defaultMapper") JsonMapper mapper) {
        return new JacksonJsonDeserializer(mapper);
    }

    @Bean
    public JacksonJsonDiffProcessor jsonDiffProcessor(@Qualifier(value="defaultMapper") JsonMapper mapper) {
        return new JacksonJsonDiffProcessor((ObjectMapper)mapper);
    }

    @Bean
    @Qualifier(value="GraviteeDefinitionSerializer")
    public GraviteeDefinitionJacksonJsonSerializer graviteeDefinitionSerializer() {
        return new GraviteeDefinitionJacksonJsonSerializer();
    }
}

