/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.permission;

import io.gravitee.apim.core.permission.domain_service.PermissionDomainService;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.PermissionServiceImpl;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PermissionDomainServiceLegacyWrapper
implements PermissionDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PermissionDomainServiceLegacyWrapper.class);
    private final MembershipService membershipService;
    private final PermissionService permissionService;

    public PermissionDomainServiceLegacyWrapper(MembershipService membershipService, PermissionService permissionService) {
        this.membershipService = membershipService;
        this.permissionService = permissionService;
    }

    @Override
    public boolean hasExactPermissions(String organizationId, String userId, RolePermission permission, String referenceId, RolePermissionAction ... acls) {
        if (PermissionServiceImpl.isOrganizationAdmin()) {
            log.debug("User [{}] has full access because of its ORGANIZATION ADMIN role", (Object)userId);
            return true;
        }
        MembershipReferenceType membershipReferenceType = PermissionServiceImpl.ROLE_SCOPE_TO_REFERENCE_TYPE.get(permission.getScope());
        Map<String, char[]> permissions = this.membershipService.getUserMemberPermissions(new ExecutionContext(organizationId), membershipReferenceType, referenceId, userId);
        return this.checkForExactPermissions(permissions, permission.getPermission(), acls);
    }

    @Override
    public boolean hasPermission(String organizationId, String userId, RolePermission permission, String referenceId, RolePermissionAction ... acls) {
        return this.permissionService.hasPermission(new ExecutionContext(organizationId), userId, permission, referenceId, acls);
    }
}

